/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import com.teamscale.index.repository.git.gerrit.data.CommentInfo;
import com.teamscale.index.repository.git.gerrit.data.FileInfo;
import com.teamscale.index.repository.git.gerrit.data.ReviewInfo;
import com.teamscale.index.repository.git.gerrit.data.ReviewInput;
import com.teamscale.index.repository.git.gerrit.data.RobotCommentInfo;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface IGerritRestApi
extends IRetrofitApi {
    @GET(value="a/projects/")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Call<ResponseBody> getProjects();

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="a/changes/")
    public List<ChangeInfo> queryChanges(@Query(value="q", encoded=true) String var1, @Query(value="o", encoded=true) String var2, @Query(value="S", encoded=true) int var3) throws ServiceCallException;

    @GET(value="a/changes/{changeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Call<ChangeInfo> getChange(@Path(value="changeId") String var1);

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="a/changes/{changeId}/detail")
    public ChangeInfo getChangeDetail(@Path(value="changeId") String var1) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="a/changes/{changeId}/comments")
    public Map<String, List<CommentInfo>> getChangeComments(@Path(value="changeId") String var1) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="a/changes/{changeId}/robotcomments")
    public Map<String, List<RobotCommentInfo>> getRobotComments(@Path(value="changeId") String var1) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @POST(value="a/changes/{changeId}/revisions/{commitHash}/review")
    public ReviewInfo uploadReview(@Path(value="changeId") String var1, @Path(value="commitHash") String var2, @Body ReviewInput var3) throws ServiceCallException;

    @DELETE(value="a/changes/{changeId}/reviewers/self/votes/{labelId}")
    public Void deleteReview(@Path(value="changeId") String var1, @Path(value="labelId") String var2) throws ServiceCallException;

    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    @GET(value="a/changes/{changeId}/revisions/{revision}/files/")
    public Map<String, FileInfo> getChangedFiles(@Path(value="changeId") String var1, @Path(value="revision") String var2) throws ServiceCallException;
}

