/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitea;

import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.GitBranchRetriever;
import com.teamscale.index.repository.git.gitea.GiteaUtils;
import com.teamscale.index.repository.retrievers.IBranchRetriever;
import java.net.URI;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.RepositoryException;

public class GiteaBranchRetriever
implements IBranchRetriever {
    private final Logger interactionLogger;

    public GiteaBranchRetriever(Logger interactionLogger) {
        this.interactionLogger = interactionLogger;
    }

    @Override
    public Set<String> fetchBranches(boolean projectExists, String username, @Nullable ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException, ProjectConfigurationException {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0);
        URI uri = GiteaUtils.getRepositoryCloneUri(connectorConfiguration, credentials, this.interactionLogger);
        return GitBranchRetriever.getGitBranches(uri, credentials.username, credentials.password);
    }
}

