/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.MergeRequestBuildJobHandler;
import com.teamscale.index.repository.git.gitlab.GitLabClient;
import com.teamscale.index.repository.git.gitlab.data.GitLabCommitStatus;
import java.util.List;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitLabMergeRequestBuildJobHandler
extends MergeRequestBuildJobHandler<GitLabCommitStatus> {
    private final GitLabClient gitLabClient;
    private final String repositoryName;

    public GitLabMergeRequestBuildJobHandler(GitLabClient gitLabClient, String repositoryName, IncludeExcludeRegexSupport buildIncludeExcludeRegexSupport) {
        super(buildIncludeExcludeRegexSupport);
        this.gitLabClient = gitLabClient;
        this.repositoryName = repositoryName;
    }

    @Override
    protected List<GitLabCommitStatus> getPlatformMergeRequestBuildJobs(String mergeRequestSourceHead) throws ServiceCallException {
        List<GitLabCommitStatus> commitStatuses = this.gitLabClient.getCommitStatuses(this.repositoryName, mergeRequestSourceHead);
        return CollectionUtils.filter(commitStatuses, commitStatus -> this.buildIncludeExcludeRegexSupport.isIncluded(commitStatus.name()));
    }
}

