/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Suppliers;
import com.teamscale.index.repository.git.gitlab.GitLabUtils;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jetbrains.annotations.VisibleForTesting;

public class GitLabChange {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String OLD_PATH_PROPERTY_NAME = "old_path";
    private static final String NEW_PATH_PROPERTY_NAME = "new_path";
    private static final String DIFF_PROPERTY_NAME = "diff";
    @JsonProperty(value="old_path")
    private final String oldPath;
    @JsonProperty(value="new_path")
    private String newPath;
    @JsonProperty(value="diff")
    private String diff;
    private final Supplier<TreeMap<Integer, Integer>> parallelLinesMapSupplier;

    @JsonCreator
    public GitLabChange(@JsonProperty(value="old_path") String oldPath, @JsonProperty(value="new_path") String newPath, @JsonProperty(value="diff") String diff) {
        this(oldPath, newPath, diff, (Supplier<TreeMap<Integer, Integer>>)Suppliers.memoize(() -> GitLabUtils.buildParallelLineMap(diff)));
    }

    @VisibleForTesting
    GitLabChange(String oldPath, String newPath, String diff, Supplier<TreeMap<Integer, Integer>> parallelLinesMapSupplier) {
        this.oldPath = oldPath;
        this.newPath = newPath;
        this.diff = diff;
        this.parallelLinesMapSupplier = parallelLinesMapSupplier;
    }

    public @Nullable Integer getOldLine(int newLine) {
        TreeMap<Integer, Integer> parallelLinesMap = this.parallelLinesMapSupplier.get();
        if (parallelLinesMap.isEmpty()) {
            LOGGER.warn("Computed empty parallel lines map for new line {} in '{}'.", (Object)newLine, (Object)this);
            return null;
        }
        int largestNewLine = parallelLinesMap.lastKey();
        if (newLine > largestNewLine) {
            Integer largestOldLine = parallelLinesMap.get(largestNewLine);
            CCSMAssert.isNotNull((Object)largestOldLine, () -> "Could not find largest old line for largest new line %s (original new line %s) in '%s'. ".formatted(largestNewLine, newLine, this) + "This should never happen, since we always access the last key.");
            return largestOldLine + (newLine - largestNewLine);
        }
        return parallelLinesMap.get(newLine);
    }

    public boolean isDiffEmpty() {
        return this.diff.isEmpty();
    }

    public boolean isDiffForBinaryFile() {
        return !this.isDiffEmpty() && this.diff.startsWith("Binary files");
    }

    public String getOldPath() {
        return this.oldPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String toString() {
        return "GitLabChange[ oldPath='%s', newPath='%s', diff='%s', parallelLinesMap=%s ]".formatted(this.oldPath, this.newPath, this.diff, this.parallelLinesMapSupplier.get());
    }
}

