/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.gitlab.data.GitLabDiffRefs;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GitLabPosition {
    public static final String POSITION_TYPE_TEXT = "text";
    public static final String POSITION_TYPE_FILE = "file";
    @JsonProperty(value="base_sha")
    private String baseSha;
    @JsonProperty(value="start_sha")
    private String startSha;
    @JsonProperty(value="head_sha")
    private String headSha;
    @JsonProperty(value="position_type")
    private String positionType;
    @JsonProperty(value="old_line")
    private Integer oldLine;
    @JsonProperty(value="new_line")
    private int newLine;
    @JsonProperty(value="new_path")
    private String newPath;
    @JsonProperty(value="old_path")
    private String oldPath;

    public GitLabPosition() {
    }

    public GitLabPosition(GitLabDiffRefs diffRefs, @Nullable Integer oldLine, int newLine, @Nullable String oldPath, String newPath) {
        this(diffRefs, oldPath, newPath);
        this.newLine = newLine;
        this.oldLine = oldLine;
        this.positionType = POSITION_TYPE_TEXT;
    }

    public GitLabPosition(GitLabDiffRefs diffRefs, @Nullable String oldPath, String newPath) {
        this.baseSha = diffRefs.getBaseSha();
        this.startSha = diffRefs.getStartSha();
        this.headSha = diffRefs.getHeadSha();
        this.newPath = newPath;
        this.oldPath = oldPath;
        this.positionType = POSITION_TYPE_FILE;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public String getPositionType() {
        return this.positionType;
    }

    public String toString() {
        return "GitLabPosition{baseSha='" + this.baseSha + "', startSha='" + this.startSha + "', headSha='" + this.headSha + "', positionType='" + this.positionType + "', oldLine=" + this.oldLine + ", newLine=" + this.newLine + ", newPath='" + this.newPath + "', oldPath='" + this.oldPath + "'}";
    }
}

