/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match.name;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import com.teamscale.index.repository.history.match.name.PathEntry;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class PathByNameIndexUpdater
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PathByNameIndex pathIndex;

    public void execute() throws StorageException {
        HashSet<String> uniqueFileNames = new HashSet<String>(PathByNameIndex.extractNamesFromPaths(this.contentDelta.getAllKeysAsStrings()));
        Map<String, PathEntry> pathEntriesByFileName = PathByNameIndexUpdater.createFileToEntryMap(this.pathIndex.getPathsByNames(new ArrayList<String>(uniqueFileNames)));
        this.updateKeys(pathEntriesByFileName, this.contentDelta.getAddedOrChangedKeysAsStrings(), false);
        this.updateKeys(pathEntriesByFileName, this.contentDelta.getDeletedKeysAsStrings(), true);
        this.pathIndex.setPathByNameEntries((PairList<String, PathEntry>)new PairList(pathEntriesByFileName));
    }

    private void updateKeys(Map<String, PathEntry> pathEntriesByFileName, List<String> pathsFromContentDelta, boolean isDeletedKey) {
        for (String pathFromDelta : pathsFromContentDelta) {
            String fileName = PathByNameIndex.extractNameFromPath(pathFromDelta);
            PathEntry pathEntry = pathEntriesByFileName.get(fileName);
            if (isDeletedKey) {
                this.processDeletedKey(pathEntriesByFileName, pathFromDelta, fileName, pathEntry);
                continue;
            }
            this.processAddedOrChangedKey(pathEntriesByFileName, pathFromDelta, fileName, pathEntry);
        }
    }

    private static Map<String, PathEntry> createFileToEntryMap(List<PathEntry> pathEntries) {
        HashMap<String, PathEntry> pathEntriesByFileName = new HashMap<String, PathEntry>();
        for (PathEntry pathEntry : pathEntries) {
            if (pathEntry == null) continue;
            pathEntriesByFileName.put(pathEntry.getFileName(), pathEntry);
        }
        return pathEntriesByFileName;
    }

    private void processAddedOrChangedKey(Map<String, PathEntry> result, String changedKey, String updatedName, @Nullable PathEntry pathEntry) {
        if (pathEntry == null) {
            PathEntry existingPathEntry = result.get(updatedName);
            if (existingPathEntry != null) {
                existingPathEntry.addPathWithTimestamp(changedKey, this.getSchedulingCommit().getTimestamp());
            } else {
                result.put(updatedName, new PathEntry(changedKey, this.getSchedulingCommit().getTimestamp()));
            }
        } else {
            pathEntry.addPathWithTimestamp(changedKey, this.getSchedulingCommit().getTimestamp());
            result.put(updatedName, pathEntry);
        }
    }

    private void processDeletedKey(Map<String, PathEntry> result, String deletedKey, String deletedName, PathEntry pathEntry) throws AssertionError {
        if (pathEntry == null) {
            LOGGER.error("Error in updating path index for deletions. No previous path entry found for deleted file: '" + deletedName + "'. Skipping entry.");
            return;
        }
        pathEntry.markPathAsDeleted(deletedKey, this.getSchedulingCommit().getTimestamp());
        result.put(deletedName, pathEntry);
    }
}

