/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs.client;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.rest.client.converter.ResponseBodyConverter;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.ISubscriptionRestClient;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.index.repository.git.azure_devops.IAzureDevOpsGitPullRequestRestApi;
import com.teamscale.index.repository.git.azure_devops.IAzureDevOpsGitRepositoryRestApi;
import com.teamscale.index.repository.git.azure_devops.model.AzureDevOpsGitRepositoryDto;
import com.teamscale.index.repository.tfs.client.IAzureDevOpsTfvcRestApi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.function.BiConsumerWithException;

public class TfsHttpConnection {
    private static final MediaType TEXT_HTML = MediaType.get((String)"text/html");
    private final Retrofit retrofit;
    private final String serverAddress;

    public TfsHttpConnection(ExternalCredentials credentials, HttpRequestRetryPolicy retryPolicy, Logger interactionLogger) {
        this(credentials.uri, credentials.username, credentials.password, retryPolicy, interactionLogger);
    }

    public TfsHttpConnection(String serverAddress, String username, String password, HttpRequestRetryPolicy retryPolicy, Logger interactionLogger) {
        this.serverAddress = serverAddress;
        this.retrofit = Retrofit.builder((String)this.serverAddress).withBasicNTLMAuthentication(username, password).withInteractionLogger(interactionLogger).withRetryPolicy(retryPolicy).withResponseValidators(new BiConsumerWithException[]{TfsHttpConnection::invalidCredentialsResponseValidator}).build();
    }

    private static void invalidCredentialsResponseValidator(ResponseBody value, Type type) throws IOException {
        if (Objects.equals(AzureDevOpsGitRepositoryDto.class, type) && ResponseBodyConverter.isOfContentType((MediaType)value.contentType(), (MediaType)TEXT_HTML)) {
            throw new IOException("Invalid credentials! Please check that you provided a correct and valid personal access token.");
        }
    }

    public IWorkItemRestClient createWorkItemRestClient() {
        return (IWorkItemRestClient)this.retrofit.create(IWorkItemRestClient.class);
    }

    public IAzureDevOpsGitPullRequestRestApi createPullRequestRestClient() {
        return (IAzureDevOpsGitPullRequestRestApi)this.retrofit.create(IAzureDevOpsGitPullRequestRestApi.class);
    }

    public IAzureDevOpsGitRepositoryRestApi createAzureDevOpsGitRepositoryRestClient() {
        return (IAzureDevOpsGitRepositoryRestApi)this.retrofit.create(IAzureDevOpsGitRepositoryRestApi.class);
    }

    public ISubscriptionRestClient createSubscriptionRestClient() {
        return (ISubscriptionRestClient)this.retrofit.create(ISubscriptionRestClient.class);
    }

    public IAzureDevOpsTfvcRestApi createAzureDevOpsTfvcRestClient() {
        return (IAzureDevOpsTfvcRestApi)this.retrofit.create(IAzureDevOpsTfvcRestApi.class);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }
}

