/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.diff;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.diff.DiffDescription;
import org.conqat.lib.commons.diff.DifferBase;
import org.conqat.lib.commons.diff.TextChunk;
import org.conqat.lib.commons.string.StringUtils;

public class TokenBasedDiffer
extends DifferBase<TokenElementInfo> {
    private final boolean isCaseSensitive;
    private static final Set<ETokenType.ETokenClass> CASE_INSENSITIVE_TOKEN_CLASSES = EnumSet.of(ETokenType.ETokenClass.KEYWORD, ETokenType.ETokenClass.IDENTIFIER);

    public TokenBasedDiffer(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    protected List<TextChunk> getChunks(TokenElementInfo elementInfo, boolean isLeft) {
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        boolean isJavaAnnotation = false;
        for (IToken token : ScannerUtils.getTokens((String)elementInfo.getText(), (ELanguage)elementInfo.getLanguage(), (String)elementInfo.getUniformPath())) {
            if (token.getType() == ETokenType.AT_OPERATOR && elementInfo.getLanguage() == ELanguage.JAVA) {
                isJavaAnnotation = true;
                continue;
            }
            if (isJavaAnnotation) {
                this.handleAnnotation(token, chunks);
                isJavaAnnotation = false;
            }
            if (token.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) {
                this.insertTokenFragments(token, chunks);
                continue;
            }
            this.insertToken(token, chunks, 0, 0);
        }
        return chunks;
    }

    private void handleAnnotation(IToken token, List<TextChunk> chunks) {
        String newText = "@".concat(token.getText());
        IToken annotation = token.newToken(ETokenType.ANNOTATION, token.getOffset() - 1, token.getLineNumber(), newText, token.getOriginId());
        this.insertToken(annotation, chunks, 0, 0);
    }

    protected String getElementText(TokenElementInfo element) {
        return element.getText();
    }

    protected DiffDescription postProcessDiffDescription(DiffDescription diffDescription) {
        DiffDescription mergedDescription = new DiffDescription(this.getDiffName());
        UnmodifiableList leftChangeLines = diffDescription.getLeftChangeLines();
        UnmodifiableList rightChangeLines = diffDescription.getRightChangeLines();
        if (leftChangeLines.size() == 0 || rightChangeLines.size() == 0) {
            return diffDescription;
        }
        int currentConsecutiveLinesStartIndex = 0;
        for (int i = 0; i < leftChangeLines.size() - 2; i += 2) {
            if ((Integer)leftChangeLines.get(i + 2) - (Integer)leftChangeLines.get(i) <= 1) continue;
            mergedDescription.addLineRegion(((Integer)leftChangeLines.get(currentConsecutiveLinesStartIndex)).intValue(), ((Integer)leftChangeLines.get(i + 1)).intValue(), ((Integer)rightChangeLines.get(currentConsecutiveLinesStartIndex)).intValue(), ((Integer)rightChangeLines.get(i + 1)).intValue());
            currentConsecutiveLinesStartIndex = i + 2;
        }
        mergedDescription.addLineRegion(((Integer)leftChangeLines.get(currentConsecutiveLinesStartIndex)).intValue(), ((Integer)leftChangeLines.get(leftChangeLines.size() - 1)).intValue(), ((Integer)rightChangeLines.get(currentConsecutiveLinesStartIndex)).intValue(), ((Integer)rightChangeLines.get(leftChangeLines.size() - 1)).intValue());
        mergedDescription.addLeftChangeRegions(diffDescription.getLeftChangeRegions());
        mergedDescription.addRightChangeRegions(diffDescription.getRightChangeRegions());
        return mergedDescription;
    }

    private void insertTokenFragments(IToken token, List<TextChunk> chunks) {
        for (IToken subToken : ScannerUtils.getTokens((String)token.getText(), (ELanguage)ELanguage.TEXT, (String)token.getOriginId())) {
            this.insertToken(subToken, chunks, token.getOffset(), token.getLineNumber());
        }
    }

    private void insertToken(IToken token, List<TextChunk> chunks, int baseOffset, int baseLine) {
        String comparisonText = token.getText();
        if (!this.isCaseSensitive && CASE_INSENSITIVE_TOKEN_CLASSES.contains(token.getType().getTokenClass())) {
            comparisonText = comparisonText.toLowerCase();
        }
        int startOffset = baseOffset + token.getOffset();
        int endOffset = baseOffset + token.getEndOffset() + 1;
        int startLine = baseLine + token.getLineNumber() + 1;
        int endLine = startLine + StringUtils.countLines((String)comparisonText);
        chunks.add(new TextChunk(startOffset, endOffset, startLine, endLine, comparisonText));
    }

    protected String getDiffName() {
        return "token-based";
    }
}

