/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PathLookupUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    static double getScore(String match, String suffix) {
        return (double)UniformPathUtils.splitPath((String)suffix).length / (double)UniformPathUtils.splitPath((String)match).length;
    }

    public static String normalizeAndReversePathEnsureEnding(String path) {
        return StringUtils.ensureEndsWith((String)PathLookupUtils.normalizeAndReversePath(path), (String)UniformPathUtils.SEPARATOR);
    }

    static String normalizeAndReversePath(String path) {
        CCSMAssert.isNotNull((Object)path);
        return StringUtils.reverse((String)UniformPathUtils.cleanPath((String)UniformPathUtils.normalizeAllSeparators((String)path.toLowerCase())));
    }

    public static String stripLeadingSlash(String path) {
        return StringUtils.stripPrefix((String)path, (String)UniformPathUtils.SEPARATOR);
    }

    static Pair<String, ImmutableList<String>> applyPlausibilityLookupOptions(String path, @NonNull PathLookupOptions options, Pair<String, ImmutableList<String>> lookupResult) {
        return Pair.createPair((Object)((String)lookupResult.getFirst()), PathLookupUtils.applyPlausibilityLookupOptions(path, options, (ImmutableList<String>)((ImmutableList)lookupResult.getSecond())));
    }

    static ImmutableList<String> applyPlausibilityLookupOptions(String path, @NonNull PathLookupOptions options, ImmutableList<String> lookedUpPaths) {
        IPathMatchingPlausibilityCheck plausibilityCheck = options.getPlausibilityCheck();
        if (plausibilityCheck == null) {
            return lookedUpPaths;
        }
        ImmutableList<String> filteredPaths = PathLookupUtils.applyPlausibilityCheck(path, lookedUpPaths, plausibilityCheck);
        if (options.shouldIgnorePlausibilityCheckIfFiltersOutAllPaths() && filteredPaths.isEmpty()) {
            return lookedUpPaths;
        }
        return filteredPaths;
    }

    static ImmutableList<String> applyPlausibilityCheck(String path, ImmutableList<String> lookupResult, @Nullable IPathMatchingPlausibilityCheck plausibilityCheck) {
        if (plausibilityCheck == null) {
            return lookupResult;
        }
        ImmutableList filteredPaths = (ImmutableList)lookupResult.stream().filter(possiblePath -> plausibilityCheck.check((String)possiblePath, path)).collect(ImmutableList.toImmutableList());
        if (filteredPaths.isEmpty()) {
            LOGGER.warn("There are no known valid paths which passed the plausibility check for path {}", (Object)path);
        }
        return filteredPaths;
    }

    static Optional<String> determineHighestScoringMatch(String path, Pair<String, ImmutableList<String>> lookupResult, double pathSuffixSizeRatioThreshold) {
        List possiblePaths = (List)lookupResult.getSecond();
        if (possiblePaths.isEmpty()) {
            return Optional.empty();
        }
        if (possiblePaths.size() == 1) {
            return Optional.of((String)possiblePaths.getFirst());
        }
        String matchWithMinEditDistance = PathLookupUtils.getPathWithMinEditDistance(path, possiblePaths);
        String suffix = UniformPathUtils.normalizeAllSeparators((String)((String)lookupResult.getFirst()));
        double score = PathLookupUtils.getScore((String)possiblePaths.getFirst(), suffix);
        if (score <= pathSuffixSizeRatioThreshold) {
            LOGGER.warn("Ignoring weak path matching '{}' for report path '{}' as common suffix '{}' is too small in relation to match", (Object)matchWithMinEditDistance, (Object)path, (Object)suffix);
            return Optional.empty();
        }
        if (possiblePaths.size() > 1) {
            LOGGER.warn("There are at least two possible, plausible matches for path '{}':{}\nChoosing the first one due to a smaller edit distance.\n", (Object)path, (Object)StringUtils.concat(possiblePaths.subList(0, 2), (String)"\n"));
            return Optional.of(matchWithMinEditDistance);
        }
        return Optional.of(matchWithMinEditDistance);
    }

    static int getLongestMatchingPathPrefixLength(String normalizedPathReversed, String reversedPathToMatch) {
        int lastSeparatorIndex = 0;
        for (int i = 0; i < Math.min(normalizedPathReversed.length(), reversedPathToMatch.length()); ++i) {
            char firstChar = normalizedPathReversed.charAt(i);
            char secondChar = reversedPathToMatch.charAt(i);
            if (secondChar != firstChar) break;
            if (firstChar != '/') continue;
            lastSeparatorIndex = i;
        }
        return lastSeparatorIndex;
    }

    private static String getPathWithMinEditDistance(String path, List<String> possiblePaths) {
        String matchWithMinEditDistance = possiblePaths.getFirst();
        if (possiblePaths.size() > 1) {
            matchWithMinEditDistance = possiblePaths.stream().min(Comparator.comparingInt(uniformPath -> StringUtils.editDistance((String)uniformPath, (String)path))).get();
        }
        return matchWithMinEditDistance;
    }

    static boolean isOnlyFileName(String path) {
        return path.indexOf(47) < 0;
    }

    static float readPathLookupThresholdProperty() {
        return Float.parseFloat(System.getProperty("com.teamscale.path-lookup.suffix-threshold", "0"));
    }

    private PathLookupUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

