/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.SchemaChangingRetrievalStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class MetricHidingRetrievalStrategy
extends SchemaChangingRetrievalStrategyBase {
    private final Predicate<String> includedMetricsPredicate;

    private MetricHidingRetrievalStrategy(Collection<Predicate<String>> includedMetricsPredicates, IMetricRetrievalStrategy delegate) {
        super(delegate);
        this.includedMetricsPredicate = includedMetricsPredicates.stream().reduce(Predicate::or).orElse(ignored -> true);
    }

    public static MetricHidingRetrievalStrategy ofMetrics(Collection<Predicate<String>> includedMetricsPredicates, IMetricRetrievalStrategy delegate) {
        return new MetricHidingRetrievalStrategy(includedMetricsPredicates, delegate);
    }

    @Override
    protected MetricDirectorySchema updateSchema(MetricDirectorySchema schema) {
        return this.hideMetricsFromSchema(schema);
    }

    private MetricDirectorySchema hideMetricsFromSchema(MetricDirectorySchema schema) {
        return new MetricDirectorySchema(schema.getAllEntries().stream().filter(Predicate.not(this::isHidden)).toList());
    }

    @Override
    protected UnaryOperator<Object[]> getMetricsUpdaterForSchema(MetricDirectorySchema schema) {
        return this.getMetricsHider(schema);
    }

    private UnaryOperator<Object[]> getMetricsHider(MetricDirectorySchema schema) {
        ArrayList<Integer> includedMetricsIndices = new ArrayList<Integer>();
        for (int metricIndex = 0; metricIndex < schema.size(); ++metricIndex) {
            if (this.isHidden(schema.getEntry(metricIndex))) continue;
            includedMetricsIndices.add(metricIndex);
        }
        return metrics -> {
            Object[] resultMetrics = new Object[includedMetricsIndices.size()];
            int resultMetricsIndex = 0;
            Iterator iterator = includedMetricsIndices.iterator();
            while (iterator.hasNext()) {
                int includedMetricIndex = (Integer)iterator.next();
                resultMetrics[resultMetricsIndex++] = metrics[includedMetricIndex];
            }
            return resultMetrics;
        };
    }

    private boolean isHidden(MetricDirectorySchemaEntry entry) {
        return this.isHidden(entry.getName());
    }

    private boolean isHidden(String name) {
        return !this.includedMetricsPredicate.test(name);
    }
}

