/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.reviews;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ElementReviewCommit
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private final String user;
    private final String uniformPath;
    private final EReviewStatus reviewStatus;

    public ElementReviewCommit(CommitDescriptor commit, String user, String uniformPath, EReviewStatus reviewStatus) {
        super(commit);
        this.user = user;
        this.uniformPath = uniformPath;
        this.reviewStatus = reviewStatus;
    }

    public String getUser() {
        return this.user;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public EReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }

    @ExportToTypeScript
    @IndexValueClass(containedInBackup=true)
    public static enum EReviewStatus {
        DONE("Done", ETrafficLightColor.GREEN),
        REWORK("In rework", ETrafficLightColor.ORANGE),
        REVIEW("In review", ETrafficLightColor.YELLOW),
        NONE("No review yet", ETrafficLightColor.UNKNOWN),
        UNREVIEWED_CHANGES("Unreviewed changes", ETrafficLightColor.RED);

        private final String readableName;
        private final ETrafficLightColor color;

        private EReviewStatus(String readableName, ETrafficLightColor color) {
            this.readableName = readableName;
            this.color = color;
        }

        public String getReadableName() {
            return this.readableName;
        }

        public ETrafficLightColor getColor() {
            return this.color;
        }
    }
}

