/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.amazonaws.SdkBaseException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.teamscale.index.s3.S3Exception;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

class S3MultiPartOutputStream
extends OutputStream {
    private static final String CONTENT_TYPE = "application/zip";
    private final String uploadId;
    private final List<PartETag> eTags = new ArrayList<PartETag>();
    private final AmazonS3 s3;
    private final String bucket;
    private final String key;
    private int currentPart = 1;

    private S3MultiPartOutputStream(AmazonS3 s3, String bucket, String key, InitiateMultipartUploadResult initiateMultipartUploadResult) {
        this.s3 = s3;
        this.bucket = bucket;
        this.key = key;
        this.uploadId = initiateMultipartUploadResult.getUploadId();
    }

    public static OutputStream init(AmazonS3 client, String bucket, String key) {
        return new S3MultiPartOutputStream(client, bucket, key, client.initiateMultipartUpload(S3MultiPartOutputStream.createInitiateRequest(bucket, key)));
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("Expecting BufferedOutputStream to only call write(byte[], int, int)");
    }

    @Override
    public void write(byte @NonNull [] data, int offset, int length) throws IOException {
        try {
            UploadPartResult result = this.uploadPart(this.bucket, this.key, this.uploadId, this.currentPart, data, offset, length);
            this.eTags.add(result.getPartETag());
            ++this.currentPart;
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.bucket, this.key, this.uploadId, this.eTags);
            this.s3.completeMultipartUpload(request);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private UploadPartResult uploadPart(String bucket, String key, String uploadId, int partNumber, byte @NonNull [] data, int offset, int length) throws S3Exception {
        UploadPartRequest request = new UploadPartRequest().withBucketName(bucket).withKey(key).withUploadId(uploadId).withPartNumber(partNumber).withPartSize((long)length).withInputStream((InputStream)new ByteArrayInputStream(data, offset, length)).withLastPart(true);
        try {
            return this.s3.uploadPart(request);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    private static InitiateMultipartUploadRequest createInitiateRequest(String bucket, String key) {
        return new InitiateMultipartUploadRequest(bucket, key).withObjectMetadata(S3MultiPartOutputStream.createObjectMetadata());
    }

    private static ObjectMetadata createObjectMetadata() {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(CONTENT_TYPE);
        return metadata;
    }
}

