/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis;

import com.teamscale.index.configuration.SimulinkAnalysisConfigurationBase;
import java.util.function.Consumer;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

public abstract class SimulinkFindingAnalysisBase {
    public static final String VALUE_FINDING_PROPERTY = "Value";
    private final String groupName = SimulinkAnalysisConfigurationBase.getFindingAnalysisAnnotation(this.getClass()).name();
    protected String uniformPath;
    private Consumer<IndexFinding> consumer;

    public void runAnalysis(String uniformPath, SimulinkModel model, Consumer<IndexFinding> consumer) throws ConQATException {
        this.uniformPath = uniformPath;
        this.consumer = consumer;
        this.analyzeModel(model);
    }

    protected abstract void analyzeModel(SimulinkModel var1) throws ConQATException;

    protected IndexFinding createFinding(String message, ElementLocation location) {
        return new IndexFinding(this.groupName, this.getFindingIndexPartition(), message, location);
    }

    protected IndexFinding createFinding(String message, ElementLocation location, ETrafficLightColor assessment) {
        IndexFinding finding = this.createFinding(message, location);
        if (assessment != null) {
            finding.setAssessment(assessment);
        }
        return finding;
    }

    protected IndexFinding createFindingForBlock(SimulinkBlock block, String message, ETrafficLightColor assessment) {
        return this.createFinding(message, (ElementLocation)new QualifiedNameLocation(block.buildQualifiedName(), this.uniformPath), assessment);
    }

    protected void reportFinding(IndexFinding finding) {
        this.consumer.accept(finding);
    }

    protected void addSecondaryLocationForBlock(IndexFinding finding, SimulinkBlock block) {
        finding.addSecondaryLocation((ElementLocation)new QualifiedNameLocation(block.buildQualifiedName(), this.uniformPath));
    }

    protected void createAndReportFindingForBlock(SimulinkBlock block, String message) {
        this.createAndReportFinding(message, block, null, null);
    }

    protected void createAndReportFindingForBlock(SimulinkBlock block, String message, ETrafficLightColor assessment, Double value) {
        this.createAndReportFinding(message, block, assessment, value);
    }

    protected void createAndReportFinding(String message, SimulinkBlock block, ETrafficLightColor assessment, Double value) {
        IndexFinding finding = this.createFinding(message, (ElementLocation)new QualifiedNameLocation(block.buildQualifiedName(), this.uniformPath), assessment);
        this.setFindingProperties(finding, value);
        this.consumer.accept(finding);
    }

    protected void setFindingProperties(IndexFinding finding, Double value) {
        if (value != null) {
            finding.setProperty(VALUE_FINDING_PROPERTY, (Object)value);
        }
    }

    protected String getFindingIndexPartition() {
        return "Simulink Internal Checks";
    }
}

