/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.structure;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.structure.ShallowParsedMetricAnalyzerBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;

public class ShallowParsedStatementNestingDepthAnalyzer
extends ShallowParsedMetricAnalyzerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String METRIC_NAME = "Nesting Depth";

    @Override
    protected String getMetricName() {
        return METRIC_NAME;
    }

    @Override
    protected void calculateMetrics(TokenElementInfo element, List<ShallowEntity> entities) {
        ShallowEntity.traverse(entities, (IShallowEntityVisitor)new MaximalNestingDepthVisitor());
    }

    private static boolean isGroovyClosureArgumentOrVariable(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null || parent.ownStartTokens().isEmpty()) {
            return false;
        }
        IToken lastParentToken = (IToken)parent.ownStartTokens().get(parent.ownStartTokens().size() - 1);
        return !(lastParentToken.getLanguage() != ELanguage.GROOVY || lastParentToken.getType() != ETokenType.LPAREN && lastParentToken.getType() != ETokenType.IDENTIFIER && lastParentToken.getType() != ETokenType.EQ || parent.getType() != EShallowEntityType.STATEMENT || !parent.getSubtype().equals("simple statement") && !parent.getSubtype().equals("local variable") && !parent.getSubtype().equals("attribute") || entity.getType() != EShallowEntityType.STATEMENT || !entity.getSubtype().equals("anonymous function"));
    }

    public static String getFindingTypeId() {
        return ShallowParsedStatementNestingDepthAnalyzer.getFindingTypeId(METRIC_NAME);
    }

    @Override
    protected String getValueFindingProperty() {
        return "Nesting Levels";
    }

    private final class MaximalNestingDepthVisitor
    implements IShallowEntityVisitor {
        private MaximalNestingDepthVisitor() {
        }

        public boolean visit(ShallowEntity entity) {
            if (entity.getType() == EShallowEntityType.STATEMENT) {
                entity.traverse((IShallowEntityVisitor)new NestingDepthVisitor());
                return false;
            }
            return true;
        }

        public void endVisit(ShallowEntity entity) {
        }
    }

    private final class NestingDepthVisitor
    implements IShallowEntityVisitor {
        private final Stack<ShallowEntity> scopes = new Stack();
        private final Set<ShallowEntity> reportedScopes = new IdentityHashSet();
        private ShallowEntity firstStatement;

        private NestingDepthVisitor() {
        }

        public boolean visit(ShallowEntity entity) {
            if (this.skipStatement(entity)) {
                return true;
            }
            if (!entity.getChildren().isEmpty()) {
                this.scopes.push(entity);
                this.firstStatement = null;
            } else if (this.firstStatement == null) {
                this.firstStatement = entity;
            }
            return true;
        }

        private boolean skipStatement(ShallowEntity entity) {
            return NestingDepthVisitor.isMethodAssignmentStatement(entity) || NestingDepthVisitor.skipReturnSwitchExpression(entity) || NestingDepthVisitor.isCppMacroGeneratedCode(entity) || entity.getType() != EShallowEntityType.STATEMENT && !NestingDepthVisitor.isMethodInAnonymousClass(entity) && !NestingDepthVisitor.isLambda(entity) || this.isAnonymousJsBlock(entity) || this.isTSQLBeginStatement(entity);
        }

        private static boolean skipReturnSwitchExpression(ShallowEntity entity) {
            boolean hasExactlyOneChild;
            boolean isReturnStatement = entity.getType() == EShallowEntityType.STATEMENT && Objects.equals(entity.getSubtype(), "simple statement") && Objects.equals(entity.getName(), "return");
            boolean bl = hasExactlyOneChild = entity.getChildren().size() == 1;
            if (isReturnStatement && hasExactlyOneChild) {
                ShallowEntity child = (ShallowEntity)entity.getChildren().getFirst();
                return child.getType() == EShallowEntityType.STATEMENT && child.getSubtype().equals("switch expression");
            }
            return false;
        }

        private static boolean isLambda(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("lambda") || ShallowParsedStatementNestingDepthAnalyzer.isGroovyClosureArgumentOrVariable(entity);
        }

        private static boolean isMethodAssignmentStatement(ShallowEntity entity) {
            boolean isJavascript = TokenStreamUtils.getLanguage((Collection)entity.includedTokens()) == ELanguage.JAVASCRIPT;
            boolean isNonReturnStatement = entity.getType() == EShallowEntityType.STATEMENT && !"return".equals(entity.getName());
            boolean firstChildIsMethod = entity.hasChildren() && ((ShallowEntity)entity.getChildren().getFirst()).getType() == EShallowEntityType.METHOD;
            return isJavascript && isNonReturnStatement && firstChildIsMethod;
        }

        private static boolean isCppMacroGeneratedCode(ShallowEntity entity) {
            if (entity.isEmpty()) {
                return true;
            }
            ELanguage language = TokenStreamUtils.getLanguage((Collection)entity.includedTokens());
            if (!LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
                return false;
            }
            return entity.hasChildren() && ((IToken)entity.includedTokens().getFirst()).getType().getTokenClass() != ETokenType.ETokenClass.KEYWORD;
        }

        private static boolean isMethodInAnonymousClass(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.METHOD && entity.getParent() != null && NestingDepthVisitor.isAnonymousClass(entity.getParent());
        }

        private static boolean isAnonymousClass(ShallowEntity entity) {
            return entity.getType() == EShallowEntityType.TYPE && "anonymous class".equals(entity.getSubtype());
        }

        private boolean isAnonymousJsBlock(ShallowEntity entity) {
            return ShallowParsedStatementNestingDepthAnalyzer.this.currentElement.getLanguage() == ELanguage.JAVASCRIPT && entity.getType() == EShallowEntityType.STATEMENT && "anonymous block".equals(entity.getSubtype());
        }

        private boolean isTSQLBeginStatement(ShallowEntity entity) {
            return ShallowParsedStatementNestingDepthAnalyzer.this.currentElement.getLanguage() == ELanguage.TSQL && entity.getType() == EShallowEntityType.STATEMENT && Objects.equals(entity.getSubtype(), "block");
        }

        public void endVisit(ShallowEntity entity) {
            if (this.scopes.isEmpty()) {
                return;
            }
            if (this.scopes.peek() != entity) {
                return;
            }
            if (!this.reportedScopes.contains(entity) && this.firstStatement != null) {
                int startLine = this.firstStatement.getStartLine();
                ShallowEntity lastSibling = this.firstStatement;
                if (this.firstStatement.getParent() != null) {
                    lastSibling = (ShallowEntity)CollectionUtils.getLast((List)this.firstStatement.getParent().getChildren());
                }
                int endLine = Objects.requireNonNull(lastSibling).getEndLine();
                int fileSize = ShallowParsedStatementNestingDepthAnalyzer.this.currentLineOffsetConverter.getLineCount();
                if (startLine > endLine) {
                    LOGGER.warn("Skipping nesting area with negative length (possibly caused by macro expansion) in {}", (Object)ShallowParsedStatementNestingDepthAnalyzer.this.currentElement.getUniformPath());
                } else if (fileSize < endLine) {
                    LOGGER.warn("Skipping nesting area in lines [{}, {}]. The end line is beyond the file size of {}. This may indicate syntax errors in the corresponding source file: {}", (Object)startLine, (Object)endLine, (Object)fileSize, (Object)ShallowParsedStatementNestingDepthAnalyzer.this.currentElement.getUniformPath());
                } else {
                    this.reportNesting(startLine, endLine);
                }
            }
            this.scopes.pop();
        }

        private void reportNesting(int startLine, int endLine) {
            int filteredStartOffset = ShallowParsedStatementNestingDepthAnalyzer.this.currentLineOffsetConverter.getOffset(startLine);
            int filteredEndOffset = ShallowParsedStatementNestingDepthAnalyzer.this.currentLineOffsetConverter.getOffset(endLine + 1) - 1;
            int rawStartOffset = ShallowParsedStatementNestingDepthAnalyzer.this.currentOffsetTransformer.getUnfilteredOffset(filteredStartOffset);
            int rawEndOffset = ShallowParsedStatementNestingDepthAnalyzer.this.currentOffsetTransformer.getUnfilteredOffset(filteredEndOffset);
            int rawStartLine = ShallowParsedStatementNestingDepthAnalyzer.this.currentRawLineOffsetConverter.getLine(rawStartOffset);
            int rawEndLine = ShallowParsedStatementNestingDepthAnalyzer.this.currentRawLineOffsetConverter.getLine(rawEndOffset);
            ShallowParsedStatementNestingDepthAnalyzer.this.reportMetricValue(this.countScopes(), (ElementLocation)new TextRegionLocation(ShallowParsedStatementNestingDepthAnalyzer.this.currentElement.getUniformPath(), rawStartOffset, rawEndOffset, rawStartLine, rawEndLine));
            this.reportedScopes.addAll(this.scopes);
        }

        private int countScopes() {
            return (int)this.scopes.stream().filter(entity -> !NestingDepthVisitor.isLambda(entity)).count();
        }
    }
}

