/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.index.ArchitecturePathDataRetriever;
import com.teamscale.index.testgap.index.CodeScopePathDataRetriever;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.UniformPathDataRetriever;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.TgaRequestBase;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TgaPathRequest
extends TgaRequestBase {
    private final UniformPath pathPrefix;

    public TgaPathRequest(UniformPath pathPrefix, long baseline, CommitDescriptor endCommit, CoverageSourceParameterBase coverageParameters, ETgaAssessmentType assessmentType, IProjectId projectId, IndexLayer indexLayer) {
        super(coverageParameters, assessmentType, baseline, endCommit, projectId, indexLayer);
        this.pathPrefix = pathPrefix;
    }

    public UniformPath getPathPrefix() {
        return this.pathPrefix;
    }

    public boolean isArchitecturePathRequest() {
        return this.pathPrefix.isArchitecturePath();
    }

    public boolean isCodeScopePathRequest() {
        return this.pathPrefix.isCodeScopesPath();
    }

    @Override
    protected ITgaDataRetriever createDataRetriever(TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) throws StorageException {
        if (this.isArchitecturePathRequest()) {
            return new ArchitecturePathDataRetriever(this.pathPrefix, this.getPartitions(), dataRetrieverIndexes, crossAnnotator, this.testInfoFilter, tgaEnablementPerCodeScope);
        }
        if (this.isCodeScopePathRequest()) {
            return new CodeScopePathDataRetriever(this.pathPrefix, this.getPartitions(), dataRetrieverIndexes, crossAnnotator, this.testInfoFilter, tgaEnablementPerCodeScope);
        }
        return new UniformPathDataRetriever(this.pathPrefix, this.getPartitions(), dataRetrieverIndexes, crossAnnotator, this.testInfoFilter, tgaEnablementPerCodeScope);
    }

    public static TgaPathRequest createRequest(CoverageSourceParameterBase coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        CommitDescriptor endCommit = timeIntervalParameters.resolveEndCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        return TgaPathRequest.createRequest(endCommit, coverageParameters, timeIntervalParameters, tgaParameters, assessmentType, indexLayer, projectId);
    }

    public static TgaPathRequest createRequest(CommitDescriptor endCommit, CoverageSourceParameterBase coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaParameters, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        CommitDescriptor baselineCommit = timeIntervalParameters.resolveBaselineCommit((IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> projectStorageSystem));
        UniformPath requestPath = tgaParameters.getUniformPath().orElseGet(UniformPath::codeRoot);
        return new TgaPathRequest(requestPath, baselineCommit.getTimestamp(), endCommit, coverageParameters, assessmentType, projectId, indexLayer);
    }

    @Override
    protected String getTgaRequestPrefix() {
        return "Test gap data for paths starting with '" + String.valueOf(this.pathPrefix) + "'";
    }
}

