/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@Index(name="code-paths-to-tests", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class CodeToTestPathsMapIndex
implements IProjectIndex {
    private final ValueIndex<HashSet<String>> delegate;

    public CodeToTestPathsMapIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<String> getFlatListOfContainedTestPaths(List<String> codeUniformPaths) throws StorageException {
        ArrayList<String> results = new ArrayList<String>();
        this.delegate.getValues(codeUniformPaths).stream().filter(Objects::nonNull).forEach(results::addAll);
        return results;
    }

    public void setCodeToTestPathMappings(PairList<String, HashSet<String>> codeToTestPathMappings) throws StorageException {
        Map mergedCodeToTestPathMappings = codeToTestPathMappings.toMap((x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1}));
        this.delegate.setValues(new PairList(mergedCodeToTestPathMappings));
    }

    public void removeCodeToTestPathsMappings(List<String> codeUniformPaths) throws StorageException {
        this.delegate.removeValues(codeUniformPaths);
    }

    public @Nullable Set<String> getTestPaths(String uniformPath) throws StorageException {
        return (Set)this.delegate.getValue(uniformPath);
    }
}

