/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.information_retrieval.data;

import com.google.common.collect.Maps;
import com.teamscale.index.tests.information_retrieval.data.Term;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.IStringAbbreviator;

public class TermFrequencies {
    private final Map<Term, Double> termFrequencies;

    public TermFrequencies(Map<Term, Double> termFrequencies) {
        this.termFrequencies = termFrequencies;
    }

    public double getTermFrequency(Term term) {
        return this.termFrequencies.getOrDefault(term, 0.0);
    }

    public Set<Term> getTermSet() {
        return this.termFrequencies.keySet();
    }

    public String toString() {
        return this.termFrequencies.toString();
    }

    public static Map<String, Double> getExpansionOf(Map<Term, Double> termFrequencies, IStringAbbreviator abbreviator) throws StorageException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Term, Double> entry : termFrequencies.entrySet()) {
            Term term = entry.getKey();
            result.put(abbreviator.unabbreviate(term.getTermId()), entry.getValue());
        }
        return result;
    }
}

