/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.algorithm.TrackedFindingContextMatchingStrategyBase;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.algo.MaxWeightMatching;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jetbrains.annotations.VisibleForTesting;

public class ApproximateMatchingStrategy
extends TrackedFindingContextMatchingStrategyBase {
    private static final double MIN_SIMILARITY = 0.61;
    private final MaxWeightMatching.IWeightProvider<TrackedFindingWithContext, TrackedFindingWithContext> weightProvider = new ApproximateMatchingWeightProvider();

    @Override
    protected PairList<TrackedFindingWithContext, TrackedFindingWithContext> performMatching(UnmodifiableSet<TrackedFindingWithContext> oldFindingContext, UnmodifiableSet<TrackedFindingWithContext> newFindingContext) {
        PairList trackingResult = new PairList();
        ListMap<String, TrackedFindingWithContext> oldCluster = ApproximateMatchingStrategy.clusterByMessage(oldFindingContext);
        ListMap<String, TrackedFindingWithContext> newCluster = ApproximateMatchingStrategy.clusterByMessage(newFindingContext);
        HashSet commonKeys = CollectionUtils.intersectionSet((Collection)oldCluster.getKeys(), (Collection[])new Collection[]{newCluster.getKeys()});
        for (String key : commonKeys) {
            PairList<TrackedFindingWithContext, TrackedFindingWithContext> result = ApproximateMatchingStrategy.calculateTimeBoundedMatching((List)oldCluster.getCollection((Object)key), (List)newCluster.getCollection((Object)key), this.weightProvider);
            for (int i = 0; i < result.size(); ++i) {
                TrackedFindingWithContext newFinding;
                TrackedFindingWithContext oldFinding = (TrackedFindingWithContext)result.getFirst(i);
                if (this.weightProvider.getConnectionWeight((Object)oldFinding, (Object)(newFinding = (TrackedFindingWithContext)result.getSecond(i))) < 0.61) continue;
                trackingResult.add((Object)oldFinding, (Object)newFinding);
            }
        }
        return trackingResult;
    }

    private static ListMap<String, TrackedFindingWithContext> clusterByMessage(Set<TrackedFindingWithContext> findings) {
        ListMap clustered = new ListMap();
        for (TrackedFindingWithContext finding : findings) {
            clustered.add((Object)finding.getNormalizedMessage(), (Object)finding);
        }
        return clustered;
    }

    @VisibleForTesting
    static class ApproximateMatchingWeightProvider
    implements MaxWeightMatching.IWeightProvider<TrackedFindingWithContext, TrackedFindingWithContext> {
        ApproximateMatchingWeightProvider() {
        }

        public double getConnectionWeight(TrackedFindingWithContext oldFinding, TrackedFindingWithContext newFinding) {
            double uniformPathDeltaWeight;
            List<TrackedUnit> oldFindingPreContext = oldFinding.getPreContext();
            List<TrackedUnit> newFindingPreContext = newFinding.getPreContext();
            List<TrackedUnit> oldFindingPostContext = oldFinding.getPostContext();
            List<TrackedUnit> newFindingPostContext = newFinding.getPostContext();
            double contextWeight = 0.5 * (ApproximateMatchingWeightProvider.unitSimilarity(oldFindingPreContext, newFindingPreContext) + ApproximateMatchingWeightProvider.unitSimilarity(oldFindingPostContext, newFindingPostContext));
            double contentWeight = ApproximateMatchingWeightProvider.unitSimilarity(oldFinding.getContent(), newFinding.getContent());
            int contextSize = oldFindingPreContext.size() + oldFindingPostContext.size() + newFindingPreContext.size() + newFindingPostContext.size();
            int contentSize = oldFinding.getContentLength() + newFinding.getContentLength();
            double weight = (0.95 * (contextWeight * (double)contextSize + contentWeight * (double)(contentSize = Math.max(contentSize, contextSize))) + 0.05 * (uniformPathDeltaWeight = 1.0 - ApproximateMatchingWeightProvider.getNormalizedUniformPathDistance(oldFinding.getUniformPath(), newFinding.getUniformPath()))) / (double)(contextSize + contentSize);
            if (weight < 0.61) {
                return 0.0;
            }
            return weight;
        }

        private static double unitSimilarity(List<TrackedUnit> units1, List<TrackedUnit> units2) {
            CounterSet<String> fragments1 = ApproximateMatchingWeightProvider.extractFragments(units1);
            CounterSet<String> fragments2 = ApproximateMatchingWeightProvider.extractFragments(units2);
            int maxSize = Math.max(fragments1.getTotal(), fragments2.getTotal());
            if (maxSize == 0) {
                return 0.0;
            }
            int commonFragments = 0;
            for (String key : fragments1.getKeys()) {
                commonFragments += Math.min(fragments1.getValue((Object)key), fragments2.getValue((Object)key));
            }
            return (double)commonFragments / (double)maxSize;
        }

        private static CounterSet<String> extractFragments(List<TrackedUnit> units) {
            CounterSet fragments = new CounterSet();
            for (TrackedUnit unit : units) {
                if (unit.getContentFragments() == null) {
                    fragments.inc((Object)unit.getContent());
                    continue;
                }
                fragments.incAll(unit.getContentFragments());
            }
            return fragments;
        }

        private static double getNormalizedUniformPathDistance(String oldFindingPath, String newFindingPath) {
            Diff.Delta uniformPathDelta = Diff.computeDelta((Object[])UniformPathUtils.splitPath((String)oldFindingPath), (Object[])UniformPathUtils.splitPath((String)newFindingPath));
            return (double)uniformPathDelta.getSize() / (double)(oldFindingPath.length() + newFindingPath.length());
        }
    }
}

