/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.algorithm.TextRegionLocationContext;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedUnit;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TrackedFindingWithContext {
    private final TrackedFinding finding;
    private final TextRegionLocationContext locationContext;
    private final int branchIndex;

    public TrackedFindingWithContext(TrackedFinding finding, TrackedElement element, int branchIndex) {
        this.finding = finding;
        if (finding.getLocation() instanceof TextRegionLocation) {
            TextRegionLocation location = (TextRegionLocation)CCSMAssert.checkedCast((Object)finding.getLocation(), TextRegionLocation.class);
            this.locationContext = new TextRegionLocationContext(location, element);
        } else {
            this.locationContext = new TextRegionLocationContext(element);
        }
        this.branchIndex = branchIndex;
    }

    public TrackedFinding getFinding() {
        return this.finding;
    }

    public int getContentStartUnitIndex() {
        return this.locationContext.getContentStartUnitIndex();
    }

    public int getContentLength() {
        return this.locationContext.getContentLength();
    }

    public String getUniformPath() {
        return this.finding.getLocation().getUniformPath();
    }

    public String getNormalizedMessage() {
        Object ruleId = this.finding.getProperties().get("Rule ID");
        if (ruleId instanceof String) {
            return (String)ruleId;
        }
        return FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)this.finding);
    }

    public int getStartLine() {
        return ((TextRegionLocation)this.finding.getLocation()).getRawStartLine();
    }

    List<TrackedUnit> getPreContext() {
        return this.locationContext.getPreContext();
    }

    List<TrackedUnit> getContent() {
        return this.locationContext.getContent();
    }

    List<TrackedUnit> getPostContext() {
        return this.locationContext.getPostContext();
    }

    public String getExactRepresentation(boolean includeOffsets) {
        return this.getNormalizedMessage() + this.locationContext.getExactRepresentation(includeOffsets);
    }

    void setPeerElementForBranch(TrackedElement peerElement, int branchIndex) {
        if (peerElement != null) {
            this.locationContext.setPeerElementForBranch(peerElement, branchIndex);
        }
    }

    TrackedElement getPeerElementForBranch(int branchIndex) {
        return this.locationContext.getPeerElementForBranch(branchIndex);
    }

    TrackedElement getElement() {
        return this.locationContext.getElement();
    }

    public int getBranchIndex() {
        return this.branchIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackedFindingWithContext that = (TrackedFindingWithContext)o;
        return this.branchIndex == that.branchIndex && Objects.equals(this.finding, that.finding);
    }

    public int hashCode() {
        return Objects.hash(this.finding, this.branchIndex);
    }

    public String toString() {
        return this.getExactRepresentation(true);
    }
}

