/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ManualTestCaseTextRegionLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class FindingSerializationUtils {
    public static final ISerializer<TrackedFinding, byte[]> FINDING_SERIALIZER = new ISerializer<TrackedFinding, byte[]>(){

        /*
         * Enabled aggressive exception aggregation
         */
        public byte @NonNull [] serialize(@NonNull TrackedFinding value) throws StorageException {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dos = new DataOutputStream(bos);){
                    FindingSerializationUtils.serializeTrackedFinding(value, dos);
                    dos.flush();
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        public @NonNull TrackedFinding deserialize(byte @NonNull [] bytes) throws StorageException {
            TrackedFinding trackedFinding;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                trackedFinding = FindingSerializationUtils.deserializeTrackedFinding(dis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException((Throwable)e);
                }
            }
            dis.close();
            return trackedFinding;
        }
    };
    public static final ISerializer<List<TrackedFinding>, byte[]> FINDING_LIST_SERIALIZER = new ISerializer<List<TrackedFinding>, byte[]>(){

        /*
         * Enabled aggressive exception aggregation
         */
        public byte @NonNull [] serialize(@NonNull List<TrackedFinding> value) throws StorageException {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream dos = new DataOutputStream(bos);){
                    FindingSerializationUtils.serializeFindingsList(value, dos);
                    dos.flush();
                    byArray = bos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        public @NonNull List<TrackedFinding> deserialize(byte @NonNull [] bytes) throws StorageException {
            List<TrackedFinding> list;
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                list = FindingSerializationUtils.deserializeFindingsList(dis);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StorageException((Throwable)e);
                }
            }
            dis.close();
            return list;
        }
    };

    public static void serializeFindingsList(List<TrackedFinding> findings, DataOutput out) throws IOException {
        out.writeInt(findings.size());
        for (TrackedFinding finding : findings) {
            FindingSerializationUtils.serializeTrackedFinding(finding, out);
        }
    }

    public static List<TrackedFinding> deserializeFindingsList(DataInput in) throws IOException {
        int count = in.readInt();
        ArrayList<TrackedFinding> list = new ArrayList<TrackedFinding>();
        for (int i = 0; i < count; ++i) {
            list.add(FindingSerializationUtils.deserializeTrackedFinding(in));
        }
        return list;
    }

    private static void serializeTrackedFinding(TrackedFinding finding, DataOutput out) throws IOException {
        FindingSerializationUtils.serializeIndexFinding((IndexFinding)finding, out);
        out.writeUTF(finding.getId());
        FindingSerializationUtils.writeCommit(out, finding.getBirthCommit());
        out.writeUTF(finding.getFindingIndexPartition());
        FindingSerializationUtils.writeCommit(out, finding.getDeathCommit());
    }

    private static void writeCommit(DataOutput out, CommitDescriptor commit) throws IOException {
        out.writeBoolean(commit != null);
        if (commit != null) {
            out.writeUTF(commit.getBranchName());
            out.writeLong(commit.getTimestamp());
        }
    }

    private static TrackedFinding deserializeTrackedFinding(DataInput in) throws IOException {
        return new TrackedFinding(FindingSerializationUtils.deserializeIndexFinding(in), in.readUTF(), FindingSerializationUtils.readCommit(in), in.readUTF(), FindingSerializationUtils.readCommit(in), null);
    }

    private static CommitDescriptor readCommit(DataInput in) throws IOException {
        boolean commitPresent = in.readBoolean();
        if (!commitPresent) {
            return null;
        }
        String branchName = in.readUTF();
        long timestamp = in.readLong();
        return new CommitDescriptor(branchName, timestamp);
    }

    private static void serializeIndexFinding(IndexFinding finding, DataOutput out) throws IOException {
        FindingSerializationUtils.serializeDetachedFinding((DetachedFinding)finding, out);
        out.writeLong(finding.getAnalysisTimestamp());
        out.writeUTF(finding.getTypeId());
        out.writeBoolean(finding.getCodeScopeName() != null);
        if (finding.getCodeScopeName() != null) {
            out.writeUTF(finding.getCodeScopeName().name());
        }
    }

    private static IndexFinding deserializeIndexFinding(DataInput in) throws IOException {
        IndexFinding finding = new IndexFinding(FindingSerializationUtils.deserializeDetachedFinding(in), in.readLong(), in.readUTF());
        if (in.readBoolean()) {
            finding.setCodeScopeName(new CodeScopeName(in.readUTF()));
        }
        return finding;
    }

    private static void serializeDetachedFinding(DetachedFinding finding, DataOutput out) throws IOException {
        out.writeUTF(finding.getGroupName());
        out.writeUTF(finding.getCategoryName());
        out.writeUTF(finding.getMessage());
        FindingSerializationUtils.serializeLocation(finding.getLocation(), out);
        ETrafficLightColor assessment = finding.getAssessment();
        if (assessment == null) {
            out.writeByte(0);
        } else {
            out.writeByte(assessment.ordinal() + 1);
        }
        out.writeInt(finding.getSiblingLocations().size());
        for (ElementLocation elementLocation : finding.getSiblingLocations()) {
            FindingSerializationUtils.serializeLocation(elementLocation, out);
        }
        FindingSerializationUtils.serializeSecondaryLocations(finding, out);
        out.writeShort(finding.getProperties().size());
        for (Map.Entry entry : finding.getProperties().entrySet()) {
            out.writeUTF((String)entry.getKey());
            StorageUtils.writeCompactObject(entry.getValue(), (DataOutput)out);
        }
        FindingSerializationUtils.serializeStatementPath(finding, out);
        FindingSerializationUtils.serializeGuidelineMapping(finding, out);
    }

    private static void serializeGuidelineMapping(DetachedFinding finding, DataOutput out) throws IOException {
        SetMap guidelineMapping = finding.getGuidelineMapping();
        if (guidelineMapping != null) {
            out.writeShort(guidelineMapping.size());
            for (String guideline : guidelineMapping.getKeys()) {
                out.writeUTF(guideline);
                Set rules = (Set)guidelineMapping.getCollection((Object)guideline);
                out.writeShort(rules.size());
                for (String rule : rules) {
                    out.writeUTF(rule);
                }
            }
        } else {
            out.writeShort(0);
        }
    }

    private static void serializeStatementPath(DetachedFinding finding, DataOutput out) throws IOException {
        if (finding.getStatementPath() != null) {
            out.writeShort(finding.getStatementPath().size());
            for (int i = 0; i < finding.getStatementPath().size(); ++i) {
                out.writeInt(i);
                StorageUtils.writeCompactObject(finding.getStatementPath().get(i), (DataOutput)out);
            }
        } else {
            out.writeShort(0);
        }
    }

    private static void serializeSecondaryLocations(DetachedFinding finding, DataOutput out) throws IOException {
        out.writeInt(finding.getSecondaryLocations().size());
        for (ElementLocation secondaryLocation : finding.getSecondaryLocations()) {
            if (finding.getLocation().getUniformPath().equals(secondaryLocation.getUniformPath())) {
                secondaryLocation = FindingSerializationUtils.cloneLocationWithUniformPath(secondaryLocation, "");
            }
            FindingSerializationUtils.serializeLocation(secondaryLocation, out);
        }
    }

    private static ElementLocation cloneLocationWithUniformPath(ElementLocation location, String uniformPath) {
        if (location instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)location;
            if (textRegionLocation instanceof TeamscaleIssueFieldLocation) {
                TeamscaleIssueFieldLocation teamscaleIssueFieldLocation = (TeamscaleIssueFieldLocation)textRegionLocation;
                if (textRegionLocation instanceof ManualTestCaseTextRegionLocation) {
                    ManualTestCaseTextRegionLocation manualTestCaseTextRegionLocation = (ManualTestCaseTextRegionLocation)textRegionLocation;
                    return new ManualTestCaseTextRegionLocation(uniformPath, manualTestCaseTextRegionLocation.getIssueId(), manualTestCaseTextRegionLocation.getStartOffset(), manualTestCaseTextRegionLocation.getEndOffset(), manualTestCaseTextRegionLocation.getStartLine(), manualTestCaseTextRegionLocation.getEndLine(), manualTestCaseTextRegionLocation.getStartStepIndex(), manualTestCaseTextRegionLocation.startsInStepAction(), manualTestCaseTextRegionLocation.getEndStepIndex(), manualTestCaseTextRegionLocation.endsInStepAction(), manualTestCaseTextRegionLocation.getAffectedField(), (List)manualTestCaseTextRegionLocation.getGapLocations());
                }
                return new TeamscaleIssueFieldLocation(uniformPath, teamscaleIssueFieldLocation.getIssueId(), teamscaleIssueFieldLocation.getStartOffset(), teamscaleIssueFieldLocation.getEndOffset(), teamscaleIssueFieldLocation.getStartLine(), teamscaleIssueFieldLocation.getEndLine(), teamscaleIssueFieldLocation.getAffectedField());
            }
            return new TextRegionLocation(uniformPath, textRegionLocation.getRawStartOffset(), textRegionLocation.getRawEndOffset(), textRegionLocation.getRawStartLine(), textRegionLocation.getRawEndLine());
        }
        if (location instanceof QualifiedNameLocation) {
            QualifiedNameLocation qualifiedNameLocation = (QualifiedNameLocation)location;
            return new QualifiedNameLocation(qualifiedNameLocation.getQualifiedName(), uniformPath);
        }
        if (location instanceof TeamscaleIssueLocation) {
            TeamscaleIssueLocation teamscaleIssueLocation = (TeamscaleIssueLocation)location;
            return new TeamscaleIssueLocation(uniformPath, teamscaleIssueLocation.getIssueId());
        }
        return new ElementLocation(uniformPath);
    }

    private static DetachedFinding deserializeDetachedFinding(DataInput in) throws IOException {
        String groupName = in.readUTF();
        String categoryName = in.readUTF();
        String message = in.readUTF();
        ElementLocation location = FindingSerializationUtils.deserializeLocation(in);
        ETrafficLightColor assessment = null;
        byte assessmentIndex = in.readByte();
        if (assessmentIndex != 0) {
            assessment = ETrafficLightColor.values()[assessmentIndex - 1];
        }
        DetachedFinding finding = new DetachedFinding(groupName, categoryName, message, location, assessment);
        int siblingCount = in.readInt();
        for (int i = 0; i < siblingCount; ++i) {
            finding.addSiblingLocation(FindingSerializationUtils.deserializeLocation(in));
        }
        FindingSerializationUtils.readSecondaryLocations(in, location, finding);
        int propertyCount = in.readShort();
        for (int i = 0; i < propertyCount; ++i) {
            finding.setProperty(in.readUTF(), StorageUtils.readCompactObject((DataInput)in));
        }
        FindingSerializationUtils.readStatementPath(in, finding);
        FindingSerializationUtils.readGuidelineMapping(in, finding);
        return finding;
    }

    private static void readGuidelineMapping(DataInput in, DetachedFinding finding) throws IOException {
        int guidelineCount;
        try {
            guidelineCount = in.readShort();
        }
        catch (EOFException e) {
            return;
        }
        if (guidelineCount == 0) {
            return;
        }
        SetMap guidelineMapping = new SetMap();
        for (int i = 0; i < guidelineCount; ++i) {
            String guideline = in.readUTF();
            int ruleCount = in.readShort();
            for (int j = 0; j < ruleCount; ++j) {
                guidelineMapping.add((Object)guideline, (Object)in.readUTF());
            }
        }
        finding.setGuidelineMapping(guidelineMapping);
    }

    private static void readStatementPath(DataInput in, DetachedFinding finding) throws IOException {
        int statementPathLength;
        try {
            statementPathLength = in.readShort();
        }
        catch (EOFException e) {
            return;
        }
        if (statementPathLength > 0) {
            finding.setStatementPath(new ArrayList(statementPathLength));
        }
        for (int i = 0; i < statementPathLength; ++i) {
            in.readInt();
            finding.getStatementPath().add((StatementPathElement)StorageUtils.readCompactObject((DataInput)in));
        }
    }

    private static void readSecondaryLocations(DataInput in, ElementLocation location, DetachedFinding finding) throws IOException {
        int secondaryLocationCount = in.readInt();
        for (int i = 0; i < secondaryLocationCount; ++i) {
            ElementLocation secondaryLocation = FindingSerializationUtils.deserializeLocation(in);
            if (StringUtils.isEmpty((String)secondaryLocation.getUniformPath())) {
                secondaryLocation = FindingSerializationUtils.cloneLocationWithUniformPath(secondaryLocation, location.getUniformPath());
            }
            finding.addSecondaryLocation(secondaryLocation);
        }
    }

    private static void serializeLocation(ElementLocation location, DataOutput out) throws IOException {
        out.writeByte(FindingSerializationUtils.getLocationType(location.getClass()));
        out.writeUTF(location.getUniformPath());
        if (location instanceof TextRegionLocation) {
            TextRegionLocation textRegionLocation = (TextRegionLocation)location;
            out.writeInt(textRegionLocation.getRawStartOffset());
            out.writeInt(textRegionLocation.getRawEndOffset());
            out.writeInt(textRegionLocation.getRawStartLine());
            out.writeInt(textRegionLocation.getRawEndLine());
            if (location instanceof TeamscaleIssueFieldLocation) {
                TeamscaleIssueFieldLocation teamscaleIssueFieldLocation = (TeamscaleIssueFieldLocation)location;
                out.writeUTF(teamscaleIssueFieldLocation.getIssueId());
                out.writeInt(teamscaleIssueFieldLocation.getFieldStartOffset());
                out.writeInt(teamscaleIssueFieldLocation.getFieldEndOffset());
                out.writeInt(teamscaleIssueFieldLocation.getFieldStartLine());
                out.writeInt(teamscaleIssueFieldLocation.getFieldEndLine());
                out.writeUTF(teamscaleIssueFieldLocation.getAffectedField());
                if (location instanceof ManualTestCaseTextRegionLocation) {
                    ManualTestCaseTextRegionLocation manualTestCaseTextRegionLocation = (ManualTestCaseTextRegionLocation)location;
                    out.writeInt(manualTestCaseTextRegionLocation.getStartStepIndex());
                    out.writeBoolean(manualTestCaseTextRegionLocation.startsInStepAction());
                    out.writeInt(manualTestCaseTextRegionLocation.getEndStepIndex());
                    out.writeBoolean(manualTestCaseTextRegionLocation.endsInStepAction());
                    FindingSerializationUtils.serializeGapLocations((List<ManualTestCaseTextRegionLocation.GapLocation>)manualTestCaseTextRegionLocation.getGapLocations(), out);
                }
            }
        } else if (location instanceof QualifiedNameLocation) {
            out.writeUTF(((QualifiedNameLocation)location).getQualifiedName());
        } else if (location instanceof TeamscaleIssueLocation) {
            TeamscaleIssueLocation issueLocation = (TeamscaleIssueLocation)location;
            out.writeUTF(issueLocation.getIssueId());
        }
    }

    private static byte getLocationType(Class<? extends ElementLocation> locationClass) throws IOException {
        if (ElementLocation.class.equals(locationClass)) {
            return 1;
        }
        if (TextRegionLocation.class.equals(locationClass)) {
            return 2;
        }
        if (QualifiedNameLocation.class.equals(locationClass)) {
            return 3;
        }
        if (ManualTestCaseTextRegionLocation.class.equals(locationClass)) {
            return 4;
        }
        if (TeamscaleIssueFieldLocation.class.equals(locationClass)) {
            return 5;
        }
        if (TeamscaleIssueLocation.class.equals(locationClass)) {
            return 6;
        }
        throw new IOException("Unsupported location type: " + locationClass.getName());
    }

    private static ElementLocation deserializeLocation(DataInput in) throws IOException {
        byte type = in.readByte();
        String uniformPath = in.readUTF();
        return switch (type) {
            case 1 -> new ElementLocation(uniformPath);
            case 2 -> new TextRegionLocation(uniformPath, in.readInt(), in.readInt(), in.readInt(), in.readInt());
            case 3 -> new QualifiedNameLocation(in.readUTF(), uniformPath);
            case 4 -> FindingSerializationUtils.parseManualTestCaseTextRegionLocation(in, uniformPath);
            case 5 -> FindingSerializationUtils.parseTeamscaleIssueFieldLocation(in, uniformPath);
            case 6 -> FindingSerializationUtils.parseTeamscaleIssueLocation(in, uniformPath);
            default -> throw new IOException("Unknown/invalid location type: " + type);
        };
    }

    private static TeamscaleIssueLocation parseTeamscaleIssueLocation(DataInput in, String uniformPath) throws IOException {
        String issueId = in.readUTF();
        return new TeamscaleIssueLocation(uniformPath, issueId);
    }

    private static ManualTestCaseTextRegionLocation parseManualTestCaseTextRegionLocation(DataInput in, String uniformPath) throws IOException {
        TeamscaleIssueFieldLocation fieldLocation = FindingSerializationUtils.parseTeamscaleIssueFieldLocation(in, uniformPath);
        return new ManualTestCaseTextRegionLocation(fieldLocation, in.readInt(), in.readBoolean(), in.readInt(), in.readBoolean(), FindingSerializationUtils.deserializeGapLocations(in));
    }

    private static TeamscaleIssueFieldLocation parseTeamscaleIssueFieldLocation(DataInput in, String uniformPath) throws IOException {
        int rawStartOffset = in.readInt();
        int rawEndOffset = in.readInt();
        int rawStartLine = in.readInt();
        int rawEndLine = in.readInt();
        String issueId = in.readUTF();
        int fieldStartOffset = in.readInt();
        int fieldEndOffset = in.readInt();
        int fieldStartLine = in.readInt();
        int fieldEndLine = in.readInt();
        return new TeamscaleIssueFieldLocation(uniformPath, issueId, new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawStartOffset, fieldStartOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawEndOffset, fieldEndOffset), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawStartLine, fieldStartLine), new TeamscaleIssueFieldLocation.RawAndFieldSpecific(rawEndLine, fieldEndLine), in.readUTF());
    }

    private static void serializeGapLocations(List<ManualTestCaseTextRegionLocation.GapLocation> gaps, DataOutput out) throws IOException {
        out.writeShort(gaps.size());
        for (ManualTestCaseTextRegionLocation.GapLocation gap : gaps) {
            out.writeInt(gap.startCell.index);
            out.writeBoolean(gap.startCell.isAction);
            out.writeInt(gap.endCell.index);
            out.writeBoolean(gap.endCell.isAction);
            out.writeInt(gap.startOffset);
            out.writeInt(gap.endOffset);
        }
    }

    private static List<ManualTestCaseTextRegionLocation.GapLocation> deserializeGapLocations(DataInput in) throws IOException {
        int gapCount = in.readShort();
        if (gapCount == 0) {
            return null;
        }
        ArrayList<ManualTestCaseTextRegionLocation.GapLocation> gaps = new ArrayList<ManualTestCaseTextRegionLocation.GapLocation>(gapCount);
        for (int i = 0; i < gapCount; ++i) {
            ManualTestCaseTextRegionLocation.TestStepCellIdentifier startCell = new ManualTestCaseTextRegionLocation.TestStepCellIdentifier(in.readInt(), in.readBoolean());
            ManualTestCaseTextRegionLocation.TestStepCellIdentifier endCell = new ManualTestCaseTextRegionLocation.TestStepCellIdentifier(in.readInt(), in.readBoolean());
            gaps.add(new ManualTestCaseTextRegionLocation.GapLocation(startCell, endCell, in.readInt(), in.readInt()));
        }
        return gaps;
    }

    private FindingSerializationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

