/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

public final class CommitterIdentifiers {
    private final Set<String> identifiers = new HashSet<String>();

    public CommitterIdentifiers(String username, String fullname, Set<String> aliases, Set<String> emailAddresses) {
        this.add(username);
        this.add(fullname);
        aliases.forEach(this::add);
        emailAddresses.forEach(this::add);
        this.addPossibleUsernamesFromEmails(emailAddresses);
    }

    private void add(String identifier) {
        if (!StringUtils.isEmpty((String)identifier)) {
            this.identifiers.add(identifier.trim().toLowerCase(Locale.ROOT));
        }
    }

    private void addPossibleUsernamesFromEmails(Set<String> emailAddresses) {
        emailAddresses.stream().filter(e -> !e.contains(".")).map(e -> (String)StringUtils.splitAtFirst((String)e, (String)"@").getFirst()).forEach(this::add);
    }

    public Set<String> getIdentifiers() {
        return Collections.unmodifiableSet(this.identifiers);
    }
}

