/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public class DurableDistributedList<T extends Serializable> {
    private final IStore store;
    private final byte[] keyPrefix;
    private final String counterName;
    private final Lock lock;
    private final IMessageBroker messageBroker;

    DurableDistributedList(IStore store, String name, InternalProjectId projectId, IMessageBroker messageBroker) {
        this.store = store;
        this.keyPrefix = StringUtils.stringToBytes((String)name);
        this.counterName = "dlist-" + String.valueOf(projectId) + name;
        this.lock = store.obtainLock(this.counterName);
        this.messageBroker = messageBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T element) throws StorageException {
        this.lock.lock();
        try {
            long index = this.messageBroker.getAndIncrementCounterValue(this.counterName);
            byte[] key = ByteArrayUtils.concat((byte[][])new byte[][]{this.keyPrefix, ByteArrayUtils.intToByteArray((int)((int)index))});
            this.store.put(key, StorageUtils.serialize(element));
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return (int)this.messageBroker.getCounterValue(this.counterName);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getAllAndClear() throws StorageException {
        ArrayList values = new ArrayList();
        this.lock.lock();
        try {
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            int expectedLength = this.keyPrefix.length + 4;
            this.store.scan(this.keyPrefix, (key, value) -> {
                if (key.length != expectedLength) {
                    return;
                }
                List list = keys;
                synchronized (list) {
                    keys.add(key);
                    values.add(value);
                }
            });
            this.store.remove(keys);
            this.messageBroker.resetCounterValue(this.counterName);
        }
        finally {
            this.lock.unlock();
        }
        return CollectionUtils.mapWithException(values, StorageUtils::deserialize);
    }
}

