/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.autocomplete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.QueryAutocompleterBase;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryLexer;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.lib.commons.collections.CollectionUtils;

class QueryAutocompletionHelper {
    private final QueryAutocompleterBase autocompleter;
    private final List<QueryToken> tokens;
    private String completionPrefix = "";
    private int completionRemovalSize = 0;

    public QueryAutocompletionHelper(QueryAutocompleterBase autocompleter, String query) throws QueryParsingException {
        this.autocompleter = autocompleter;
        this.tokens = QueryLexer.tokenize(query);
        if (this.tokens.isEmpty()) {
            return;
        }
        QueryToken lastToken = (QueryToken)CollectionUtils.getLast(this.tokens);
        if (lastToken.getType() == EQueryTokenType.LITERAL && !query.endsWith(" ")) {
            this.tokens.remove(this.tokens.size() - 1);
            this.completionPrefix = lastToken.getText();
            this.completionRemovalSize = query.length() - lastToken.getPosition();
        }
    }

    public List<String> getSuggestions() {
        if (this.tokens.isEmpty()) {
            return this.getAttributeSuggestions();
        }
        String containedQueryAttribute = this.findContainsQueryAttribute();
        if (containedQueryAttribute != null) {
            return this.getValueSuggestions(containedQueryAttribute);
        }
        QueryToken lastToken = (QueryToken)CollectionUtils.getLast(this.tokens);
        switch (lastToken.getType()) {
            case PAREN_OPEN: {
                return this.getSuggestionsAfterOpenParen();
            }
            case AND: 
            case OR: 
            case NOT: {
                return this.getAttributeSuggestions();
            }
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case SMALLER_THAN: 
            case SMALLER_THAN_OR_EQUAL: 
            case LIKE: {
                return this.getValueSuggestionAfterBasicOperator();
            }
            case BRACKET_OPEN: 
            case COMMA: {
                return this.getValueSuggestionsAfterOpenBracketOrComma();
            }
        }
        return Collections.emptyList();
    }

    private List<String> getSuggestionsAfterOpenParen() {
        if (this.tokens.size() <= 1) {
            return this.getAttributeSuggestions();
        }
        if (CollectionUtils.endsWith(this.tokens, QueryToken::getType, (Object[])new EQueryTokenType[]{EQueryTokenType.ISSUE_QUERY, EQueryTokenType.PAREN_OPEN})) {
            return this.autocompleter.getFunctionArgumentsStartingWith(EQueryTokenType.ISSUE_QUERY, 0, this.completionPrefix);
        }
        QueryToken secondToLastToken = this.tokens.get(this.tokens.size() - 2);
        if (secondToLastToken.getType() == EQueryTokenType.LITERAL || secondToLastToken.getType() == EQueryTokenType.QUERY) {
            QueryToken thirdToLastToken;
            ArrayList<String> result = new ArrayList<String>(this.autocompleter.getFunctionArgumentsStartingWith(secondToLastToken.getType(), 0, this.completionPrefix));
            if (this.tokens.size() > 2 && EQueryTokenType.isInOperator((thirdToLastToken = this.tokens.get(this.tokens.size() - 3)).getType())) {
                result.addAll(this.getAttributeSuggestions());
            }
            return result;
        }
        return this.getAttributeSuggestions();
    }

    private List<String> getValueSuggestionsAfterOpenBracketOrComma() {
        int index;
        if (CollectionUtils.endsWith(this.tokens, QueryToken::getType, (Object[])new EQueryTokenType[]{EQueryTokenType.ISSUE_QUERY, EQueryTokenType.PAREN_OPEN, EQueryTokenType.LITERAL, EQueryTokenType.COMMA})) {
            return this.autocompleter.getFunctionArgumentsStartingWith(EQueryTokenType.ISSUE_QUERY, 1, this.completionPrefix);
        }
        for (index = this.tokens.size() - 1; index >= 0 && (this.tokens.get(index).getType() == EQueryTokenType.COMMA || this.tokens.get(index).getType() == EQueryTokenType.LITERAL); --index) {
        }
        if (index >= 0 && this.tokens.get(index).getType() != EQueryTokenType.BRACKET_OPEN) {
            return Collections.emptyList();
        }
        if ((index -= 4) >= 0 && this.tokens.get(index).getType() == EQueryTokenType.LITERAL) {
            return this.getValueSuggestions(this.tokens.get(index).getText());
        }
        return Collections.emptyList();
    }

    public int getCompletionRemovalSize() {
        return this.completionRemovalSize;
    }

    private List<String> getValueSuggestionAfterBasicOperator() {
        int index = this.tokens.size() - 2;
        if (index >= 1 && this.tokens.get(index).getType() == EQueryTokenType.NOT) {
            --index;
        }
        if (index >= 0 && this.tokens.get(index).getType() == EQueryTokenType.LITERAL) {
            return this.getValueSuggestions(this.tokens.get(index).getText());
        }
        return Collections.emptyList();
    }

    private List<String> getValueSuggestions(String attributeName) {
        return this.autocompleter.getValuesStartingWith(attributeName, this.completionPrefix);
    }

    private String findContainsQueryAttribute() {
        int index;
        for (index = this.tokens.size() - 1; index >= 0 && this.isSetToken(index); --index) {
        }
        if (index < 2 || this.tokens.get(index).getType() != EQueryTokenType.BRACKET_OPEN || !EQueryTokenType.isInOperator(this.tokens.get(index - 1).getType())) {
            return null;
        }
        if ((index -= 2) >= 1 && this.tokens.get(index).getType() == EQueryTokenType.NOT) {
            --index;
        }
        if (index >= 0 && this.tokens.get(index).getType() == EQueryTokenType.LITERAL) {
            return this.tokens.get(index).getText();
        }
        return null;
    }

    private boolean isSetToken(int index) {
        EQueryTokenType type = this.tokens.get(index).getType();
        return type == EQueryTokenType.COMMA || type == EQueryTokenType.LITERAL;
    }

    private List<String> getAttributeSuggestions() {
        return this.autocompleter.getAttributesStartingWith(this.completionPrefix);
    }
}

