/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.BasicQueryBase;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.StaticOperand;

public class LikeQuery
extends BasicQueryBase {
    public LikeQuery(IAttributeOperand attribute, StaticOperand value) {
        super(attribute, value);
    }

    @Override
    protected String getReadableOperator() {
        return "~";
    }

    @Override
    protected BiPredicate<Object, Object> getComparator(EKeyedObjectType type) throws QueryCompilationException {
        switch (type) {
            case NUMBER: 
            case DATE: {
                throw new QueryCompilationException("Like operation only supported for string attributes, but used for " + String.valueOf(this.attribute) + " which is of type " + String.valueOf((Object)type) + "!", type.name());
            }
            case STRING: 
            case STRING_LIST: {
                Pattern pattern;
                try {
                    pattern = Pattern.compile(this.value.getAsString());
                }
                catch (PatternSyntaxException e) {
                    throw new QueryCompilationException("Not a valid regular expression: " + this.value.getAsString() + ": " + e.getMessage(), this.value.getAsString());
                }
                return (object, ignoredStaticValue) -> pattern.matcher(object.toString()).find();
            }
        }
        throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)type), type.name());
    }
}

