/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.constraints;

import org.conqat.lib.commons.constraint.ConstraintViolationException;
import org.conqat.lib.commons.constraint.ILocalConstraint;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkElementNameConstraint
implements ILocalConstraint<SimulinkElementBase> {
    public void checkLocalConstraint(SimulinkElementBase element) throws ConstraintViolationException {
        if (element instanceof SimulinkObject) {
            return;
        }
        String name = element.getName();
        if (name == null || name.length() == 0) {
            throw new ConstraintViolationException("Element " + String.valueOf(element) + " has no name.", (Object)element);
        }
        if (SimulinkUtils.startsOrEndsWithSeparator(name)) {
            throw new ConstraintViolationException("Name of element " + String.valueOf(element) + " starts or ends with a slash.", (Object)element);
        }
    }
}

