/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;

public class SimulinkFunctionConnector
extends SimulinkElementBase {
    public SimulinkBlock getCallerBlock() {
        return this.getConnectedBlock("Caller");
    }

    public SimulinkBlock getFunctionBlock() {
        return this.getConnectedBlock("Function");
    }

    private SimulinkBlock getConnectedBlock(String parameter) {
        String callerBlockId = this.getParameter(parameter);
        if (callerBlockId == null) {
            return null;
        }
        SimulinkBlock parent = (SimulinkBlock)this.getParent();
        return parent.getSubBlockBySID(callerBlockId);
    }

    public String getCalls() {
        return this.getParameter("Calls");
    }

    public Pair<String, String> getSourcePortPosition() {
        return this.getPositionForEndpoint(true);
    }

    public Pair<String, String> getDestinationPortPosition() {
        return this.getPositionForEndpoint(false);
    }

    private Pair<String, String> getPositionForEndpoint(boolean isSource) {
        String path = this.getParameter("Path");
        if (path == null) {
            return null;
        }
        path = StringUtils.removeAll((String)path, (String[])new String[]{"[", "]"});
        int index = 0;
        String[] pathCoordinates = path.split(";");
        if (isSource) {
            index = pathCoordinates.length - 1;
        }
        String pathEndpoint = pathCoordinates[index];
        String[] position = pathEndpoint.split(",");
        return new Pair((Object)position[0], (Object)position[1]);
    }
}

