/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformationFactory;

public class JSConditionEvaluator
extends ConditionEvaluatorBase {
    private static final String ZERO_REPRESENTATION = "-?(0|0.0)";
    private static final List<Set<ETokenType>> JAVASCRIPT_OPERATORS = List.of(Set.of(ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.ANDEQ, ETokenType.XOREQ, ETokenType.OREQ), Set.of(), Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.EQEQ, ETokenType.EQEQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT, ETokenType.URSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.MOD), Set.of(ETokenType.NOT, ETokenType.COMP, ETokenType.PLUS, ETokenType.MINUS));

    JSConditionEvaluator() {
        this.addNegationsForRelational();
    }

    @Override
    protected ETokenType getAndOperator() {
        return ETokenType.ANDAND;
    }

    @Override
    protected ETokenType getOrOperator() {
        return ETokenType.OROR;
    }

    private void addNegationsForRelational() {
        this.negationsForRelational.put(ETokenType.EQEQEQ, ETokenType.NOTEQEQ);
        this.negationsForRelational.put(ETokenType.NOTEQEQ, ETokenType.EQEQEQ);
    }

    @Override
    protected ETokenType getClosingBracketType() {
        return ETokenType.RPAREN;
    }

    @Override
    protected ETokenType getOpeningBracketType() {
        return ETokenType.LPAREN;
    }

    @Override
    protected boolean isEqualOperator(ETokenType operator) {
        return operator == ETokenType.EQEQ || operator == ETokenType.EQEQEQ;
    }

    @Override
    protected boolean isNotEqualOperator(ETokenType operator) {
        return operator == ETokenType.NOTEQ || operator == ETokenType.NOTEQEQ;
    }

    @Override
    public Set<ETokenType> getBooleanOperators() {
        return Set.of(JSConditionEvaluator.getNegationOperator(), this.getAndOperator(), this.getOrOperator(), ETokenType.EQEQ, ETokenType.EQEQEQ, ETokenType.NOTEQ, ETokenType.NOTEQEQ, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ);
    }

    @Override
    public IConditionTreeNode castToBoolean(IConditionTreeNode originalNode, ExpressionTreeNode expression) {
        if (!expression.isLiteral() || expression.expression.size() != 1) {
            return originalNode;
        }
        IToken literalToken = expression.getExpression().get(0);
        ETokenType tokenType = literalToken.getType();
        switch (tokenType) {
            case NULL: 
            case NULL_LITERAL: {
                return new ConditionTreeNodeFalse();
            }
            case INTEGER_LITERAL: 
            case FLOATING_POINT_LITERAL: {
                if (literalToken.getText().matches(ZERO_REPRESENTATION)) {
                    return new ConditionTreeNodeFalse();
                }
                return new ConditionTreeNodeTrue();
            }
            case STRING_LITERAL: {
                if (literalToken.getText().isEmpty()) {
                    return new ConditionTreeNodeFalse();
                }
                return new ConditionTreeNodeTrue();
            }
        }
        if (tokenType.getTokenClass() == ETokenType.ETokenClass.LITERAL) {
            return new ConditionTreeNodeTrue();
        }
        return originalNode;
    }

    @Override
    public boolean supportsImplicitBooleanCast() {
        return true;
    }

    @Override
    public IOperatorInformation getOperatorInformation() {
        return new IOperatorInformationFactory.SimpleOperatorInformation(JAVASCRIPT_OPERATORS);
    }
}

