/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.google.common.base.Preconditions;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ICredentialsBasedConnectorDescriptor;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class CredentialsBasedConnectorDescriptorBase
extends ConnectorDescriptorBase
implements ICredentialsBasedConnectorDescriptor {
    @VisibleForTesting
    public static final String UNAVAILABLE_ACCOUNT_IDENTIFIER = "account identifier unavailable";
    @ConfigExposed(name="Account", description="The account for this connector.", required=true)
    private @Nullable AccountCredentials accountIdentifier;

    protected CredentialsBasedConnectorDescriptorBase(IConnectorEnum<?> connectorEnum, EConnectorType connectorType) {
        super(connectorEnum, connectorType);
    }

    protected CredentialsBasedConnectorDescriptorBase(IConnectorEnum<?> connectorEnum, EConnectorType connectorType, @Nullable AccountCredentials credentials) {
        super(connectorEnum, connectorType);
        this.accountIdentifier = credentials;
    }

    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        String message = "Can not resolve credentials when %s is null.";
        Preconditions.checkState((this.accountIdentifier != null ? 1 : 0) != 0, (Object)message.formatted("accountIdentifier"));
        String credentialsName = this.accountIdentifier.getAccountIdentifier();
        Preconditions.checkState((credentialsName != null ? 1 : 0) != 0, (Object)message.formatted("credentialsName"));
        try {
            ExternalCredentials credentials = this.getContext().getExternalCredentialsProvider().getExternalCredentials(credentialsName);
            if (credentials == null) {
                throw new ConnectorValidationException("No such account: " + credentialsName);
            }
            return credentials;
        }
        catch (StorageException e) {
            throw new ConnectorValidationException("Unable to load account: " + credentialsName, e);
        }
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        this.validateConnectionAndAuthenticationUsingExternalCredentials();
    }

    protected void validateConnectionAndAuthenticationUsingExternalCredentials() throws ConnectorValidationException {
        ExternalCredentials externalCredentials = this.resolveExternalCredentials();
        String url = this.getUrlFromCredentials(externalCredentials);
        this.validateHttpConnection(url);
        this.validateAccountDetails(url, externalCredentials.username, externalCredentials.password);
    }

    protected final String getUrlFromCredentials(ExternalCredentials externalCredentials) throws ConnectorValidationException {
        String url = externalCredentials.uri;
        if (this.shouldStripTrailingSlashFromUrl()) {
            url = StringUtils.stripSuffix((String)url, (String)"/");
        }
        if (StringUtils.isEmpty((String)url)) {
            throw new ConnectorValidationException("Please enter a valid url!");
        }
        return url;
    }

    protected void validateHttpConnection(String url) throws ConnectorValidationException {
        try {
            URL testUrl = new URL(url);
            URLConnection connection = testUrl.openConnection();
            connection.connect();
        }
        catch (IOException e) {
            throw new ConnectorValidationException("Could not connect to: " + url, e);
        }
    }

    protected boolean shouldStripTrailingSlashFromUrl() {
        return false;
    }

    protected abstract void validateAccountDetails(String var1, String var2, String var3) throws ConnectorValidationException;

    @Override
    public void deleteConfigurationData(ProjectStorageSystem projectStorageSystem, String uri) {
    }

    @Override
    public String getAccountIdentifier() {
        return Optional.ofNullable(this.accountIdentifier).map(AccountCredentials::getAccountIdentifier).orElse(UNAVAILABLE_ACCOUNT_IDENTIFIER);
    }
}

