/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.authenticate.ESsoAuthenticatorType;
import com.teamscale.core.authenticate.ISsoAuthenticatorOption;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.options.AutomaticSsoLoginRedirectOption;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class SsoRedirectionHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerOptionIndex serverOptionIndex;

    public SsoRedirectionHandler(ServerOptionIndex serverOptionIndex) {
        this.serverOptionIndex = serverOptionIndex;
    }

    public Optional<String> getRedirectUrl(String target, URI baseUri) {
        try {
            boolean isAutomaticSsoLoginRedirectEnabled = AutomaticSsoLoginRedirectOption.isAutomaticSsoLoginRedirectEnabled(this.serverOptionIndex);
            if (!isAutomaticSsoLoginRedirectEnabled) {
                return Optional.empty();
            }
            return this.getRedirectUrlFromSsoAuthenticators(baseUri, target);
        }
        catch (StorageException ex) {
            return Optional.empty();
        }
    }

    private Optional<String> getRedirectUrlFromSsoAuthenticators(URI baseUri, String target) throws StorageException {
        List ssoAuthenticatorNames = CollectionUtils.map((Object[])ESsoAuthenticatorType.values(), ESsoAuthenticatorType::getOptionId);
        Optional<String> redirectUrl = Optional.empty();
        for (String ssoAuthenticatorName : ssoAuthenticatorNames) {
            Map<String, IOption> options = ServerOptionRegistry.getServerMultiOptionAll(ssoAuthenticatorName, this.serverOptionIndex);
            for (IOption value : options.values()) {
                ISsoAuthenticatorOption authenticatorOption = (ISsoAuthenticatorOption)CCSMAssert.checkedCast((Object)value, ISsoAuthenticatorOption.class);
                Optional<String> currentAuthenticatorUrl = authenticatorOption.buildRedirectionLink(baseUri, target);
                if (redirectUrl.isPresent() && currentAuthenticatorUrl.isPresent()) {
                    LOGGER.error("There are multiple SSO authenticators defined, cannot redirect to SSO login page.");
                    return Optional.empty();
                }
                if (!currentAuthenticatorUrl.isPresent()) continue;
                redirectUrl = currentAuthenticatorUrl;
            }
        }
        if (redirectUrl.isEmpty()) {
            LOGGER.error("There are no SSO authenticators defined, cannot redirect to SSO login page.");
        }
        return redirectUrl;
    }
}

