/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationSynchronizeTriggerAuto;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.tfs.TfsConnection;
import com.teamscale.core.tfs.TfsException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="auth.tfs.server", name="Azure DevOps Authorization", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=200)
@IndexValueClass(containedInBackup=true)
public class TfsAuthorizationServerDescription
extends ServerDescriptionBase {
    public static final String OPTION_ID = "auth.tfs.server";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accountCredentialsName")
    @OptionFieldDescription(name="The Azure DevOps Server account")
    public String accountCredentialsName;
    @JsonProperty(value="userLoginName")
    @OptionFieldDescription(name="The property for the user login", description="If a user has no value stored with this property the user will be ignored for import. Leave empty for default behavior (DN for Windows accounts and E-Mail for other account types). ")
    public String userLoginName;
    @JsonProperty(value="updateSchedule")
    @OptionFieldDescription(name="Automatic server synchronization schedule")
    @ScheduleOption(triggerClass=TfsAuthorizationSynchronizeTriggerAuto.class)
    public String updateSchedule = "";

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.TFS;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.accountCredentialsName);
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String superError = super.validate(storageInfo, instanceConfiguration);
        if (superError != null) {
            return superError;
        }
        if (StringUtils.isEmpty((String)this.accountCredentialsName)) {
            return "Account name missing";
        }
        if (StringUtils.isEmpty((String)this.userServer)) {
            return "TFS can only be used for authorization, please specify an user server";
        }
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)storageInfo.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials credentials = this.getAccountCredentials(externalCredentialsIndex);
        if (credentials == null) {
            return "Provided account credentials do not exist, please create account credentials '" + this.accountCredentialsName + "' first";
        }
        try (TfsConnection connection = new TfsConnection(credentials);){
            TfsConnection.validateAccess(connection.getVersionControlClient());
        }
        catch (ConnectorValidationException | TfsException e) {
            return "Could not validate connection: " + ((Throwable)e).getMessage();
        }
        return null;
    }

    public ExternalCredentials getAccountCredentials(IExternalCredentialsProvider credentialsProvider) throws StorageException {
        return credentialsProvider.getExternalCredentials(this.accountCredentialsName);
    }
}

