/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AutoCompletionStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationServerDescription;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class TfsGroupAutoCompletionStrategy
extends AutoCompletionStrategyBase<TfsAuthorizationServerDescription> {
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\s+");
    private final ExternalCredentials credentials;

    public TfsGroupAutoCompletionStrategy(NamedServer<TfsAuthorizationServerDescription> server, ExternalCredentials credentials) {
        super(server);
        this.credentials = credentials;
    }

    @Override
    protected List<String> getAutoCompletions(String toComplete, int limit) throws AuthenticationToolException {
        List<String> parts = Arrays.asList(WHITESPACES_PATTERN.split(toComplete));
        return TfsAuthorizationUtils.getAllGroupNames(this.credentials).stream().sorted().filter(name -> parts.stream().allMatch(part -> name.toLowerCase().contains(part.toLowerCase()))).limit(limit).collect(Collectors.toList());
    }
}

