/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.tfs;

import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.base.SynchronizeGroupsAsyncStrategyBase;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationServerDescription;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationSynchronizeTriggerManual;
import com.teamscale.core.authenticate.tfs.TfsAuthorizationUtils;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

class TfsSynchronizeGroupsAsyncStrategy
extends SynchronizeGroupsAsyncStrategyBase<TfsAuthorizationServerDescription> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExternalCredentials externalCredentials;

    public TfsSynchronizeGroupsAsyncStrategy(NamedServer<TfsAuthorizationServerDescription> server, ExternalCredentials externalCredentials, UserIndex userIndex, UserGroupIndex groupIndex, GlobalAnalysisProgressIndex progressIndex, IImportGroupsStrategy importGroupsStrategy, IMessageBroker messageBroker) {
        super(server, userIndex, groupIndex, progressIndex, importGroupsStrategy, messageBroker);
        this.externalCredentials = externalCredentials;
    }

    @Override
    protected boolean groupExists(UserGroup group) throws AuthenticationToolException, StorageException {
        TeamFoundationIdentity groupById = TfsAuthorizationUtils.findGroupById(this.externalCredentials, group);
        if (groupById == null) {
            LOGGER.warn("Group + " + group.getName() + " cannot be found by ID on the server. Attempting lookup by name.");
            Optional<UserGroup> groupByName = TfsAuthorizationUtils.findGroupByName(this.externalCredentials, this.getServer().name(), group.getName());
            if (groupByName.isPresent()) {
                group.setRemoteGroup(groupByName.get().getRemoteGroup());
                LOGGER.warn("Group " + group.getName() + " has different ID on server. Updating " + group.getRemoteGroup() + " with " + groupByName.get().getRemoteGroup());
                this.groupIndex.setGroup(group);
                return true;
            }
        }
        return groupById != null;
    }

    @Override
    protected Class<? extends PrivilegedTriggerBase> getTriggerClass() {
        return TfsAuthorizationSynchronizeTriggerManual.class;
    }
}

