/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.cron;

import org.conqat.lib.commons.assertion.CCSMAssert;

public enum ECrontabMacro {
    YEARLY("@yearly", "0 0 1 1 *"),
    ANNUALLY("@annually", "0 0 1 1 *"),
    MONTHLY("@monthly", "0 0 1 * *"),
    WEEKLY("@weekly", "0 0 * * 0"),
    DAILY("@daily", "0 0 * * *"),
    HOURLY("@hourly", "0 * * * *"),
    MIDNIGHT("@midnight", "0 0 * * *");

    private final String macro;
    private final String expression;

    private ECrontabMacro(String macro, String expression) {
        CCSMAssert.isNotNull((Object)macro);
        CCSMAssert.isNotNull((Object)expression);
        this.macro = macro;
        this.expression = expression;
    }

    public static ECrontabMacro valueOfSchedule(String schedule) {
        for (ECrontabMacro eCrontabMacro : ECrontabMacro.values()) {
            if (!eCrontabMacro.macro.equals(schedule)) continue;
            return eCrontabMacro;
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getMacro() {
        return this.macro;
    }
}

