/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricsSerializationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class MetricDirectoryIndexBase
extends IndexBase {
    protected MetricDirectoryIndexBase(IStore store) {
        super(store);
    }

    private @Nullable MetricDirectoryEntry deserializeMetricDirectoryEntry(byte[] bytes, StorageStringAbbreviator abbreviator) throws StorageException {
        MetricDirectoryEntry metricDirectoryEntry;
        if (bytes == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            metricDirectoryEntry = MetricsSerializationUtils.deserializeMetricDirectoryEntry(dis, abbreviator);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
        dis.close();
        return metricDirectoryEntry;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeMetricDirectoryEntry(MetricDirectoryEntry value, Map<String, Integer> abbreviationMap) throws StorageException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                MetricsSerializationUtils.serializeMetricDirectoryEntry(value, dos, abbreviationMap);
                dos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public List<@Nullable MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPaths) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        List<byte[]> abbreviations = this.uniformPathsToSegmentedByteArrays(uniformPaths, abbreviator);
        ArrayList<MetricDirectoryEntry> results = new ArrayList<MetricDirectoryEntry>(uniformPaths.size());
        for (byte[] serializedEntry : this.store.get(abbreviations)) {
            results.add(this.deserializeMetricDirectoryEntry(serializedEntry, abbreviator));
        }
        return results;
    }

    public @Nullable MetricDirectoryEntry getMetricDirectoryEntry(String uniformPath) throws StorageException {
        return this.getMetricDirectoryEntries(List.of(uniformPath)).get(0);
    }

    public void setMetricDirectoryEntries(PairList<String, MetricDirectoryEntry> entries) throws StorageException {
        PairList serializedEntries = new PairList(entries.size());
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        HashSet<String> uniformPaths = new HashSet<String>(entries.size());
        for (Pair entry : entries) {
            MetricDirectoryEntry metricDirectoryEntry = (MetricDirectoryEntry)entry.getSecond();
            uniformPaths.add(metricDirectoryEntry.getUniformPath());
            uniformPaths.addAll((Collection<String>)metricDirectoryEntry.getChildMetricsMap().keySet());
        }
        Map abbreviationLookup = abbreviator.buildAbbreviationMap(uniformPaths);
        for (Pair entry : entries) {
            serializedEntries.add(new Pair((Object)this.uniformPathToSegmentedByteArray((String)entry.getFirst(), abbreviator), (Object)this.serializeMetricDirectoryEntry((MetricDirectoryEntry)entry.getSecond(), abbreviationLookup)));
        }
        this.store.put(serializedEntries);
    }

    private List<byte[]> uniformPathsToSegmentedByteArrays(List<String> uniformPaths, StorageStringAbbreviator abbreviator) throws StorageException {
        return CollectionUtils.mapWithException(uniformPaths, path -> this.uniformPathToSegmentedByteArray((String)path, abbreviator));
    }

    private byte[] uniformPathToSegmentedByteArray(String uniformPath, StorageStringAbbreviator abbreviator) throws StorageException {
        if (StringUtils.isEmpty((String)uniformPath)) {
            return new byte[0];
        }
        String[] pathSegments = UniformPathUtils.splitPath((String)StringUtils.stripSuffix((String)uniformPath, (String)"/"));
        List abbreviatedStrings = abbreviator.abbreviate(Arrays.asList(pathSegments));
        return ByteArrayUtils.serializeIntegerList((List)abbreviatedStrings);
    }

    public void setMetricDirectoryEntry(String uniformPath, MetricDirectoryEntry entry) throws StorageException {
        this.setMetricDirectoryEntries((PairList<String, MetricDirectoryEntry>)PairList.from((Object)uniformPath, (Object)entry));
    }

    public void removeMetricDirectoryEntries(List<String> uniformPaths) throws StorageException {
        this.store.remove(this.uniformPathsToSegmentedByteArrays(uniformPaths, this.store.getAbbreviator()));
    }

    public List<MetricDirectoryEntry> getMetricDirectoryEntriesForUniformPathPrefixes(List<String> prefixes) throws StorageException {
        final StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        List<byte[]> preparedPrefixes = this.uniformPathsToSegmentedByteArrays(prefixes, abbreviator);
        final ArrayList<MetricDirectoryEntry> results = new ArrayList<MetricDirectoryEntry>();
        ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                results.add(MetricDirectoryIndexBase.this.deserializeMetricDirectoryEntry(value, abbreviator));
            }
        };
        this.store.scan(preparedPrefixes, (IKeyValueCallback)callback);
        callback.throwCaughtException();
        return results;
    }

    public abstract String getName();
}

