/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.authenticate.teamscale.HashedStoredPasswordAuthenticator;
import com.teamscale.core.option.HashedPasswordOption;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.Strings;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class HashedPasswordOptionUtils {
    private static final String SALT_SEPARATOR = "##-salt-##";
    private static final String HASHING_ALGORITHM = "SHA-256";
    private static MessageDigest digest;

    public static void hashPasswords(IOption option) {
        try {
            for (Field field : HashedPasswordOptionUtils.getHashedPasswordFields(option)) {
                Object value = field.get(option);
                if (value == null || ((String)value).contains(SALT_SEPARATOR)) continue;
                String salt = HashedPasswordOptionUtils.generateSalt();
                field.set(option, HashedPasswordOptionUtils.hashPassword(Strings.toUTF8ByteArray((String)((String)value)), salt));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            CCSMAssert.fail((String)"This is not possible as we checked access before!");
        }
    }

    private static List<Field> getHashedPasswordFields(IOption option) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : OptionDescriptor.getOptionFields(option.getClass())) {
            if (!field.isAnnotationPresent(HashedPasswordOption.class)) continue;
            result.add(field);
        }
        return result;
    }

    public static boolean isPasswordCorrectForOption(String hashedPasswordAndSalt, byte[] password) {
        String[] hashAndSalt = StringUtils.splitByWholeSeparator((String)hashedPasswordAndSalt, (String)SALT_SEPARATOR);
        String salt = hashAndSalt[1];
        return HashedPasswordOptionUtils.hashPassword(password, salt).equals(hashedPasswordAndSalt);
    }

    public static synchronized String hashPassword(byte[] password, String salt) {
        HashedPasswordOptionUtils.ensureDigestInitialized();
        digest.reset();
        digest.update(password);
        digest.update(StringUtils.stringToBytes((String)salt));
        return StringUtils.encodeAsHex((byte[])digest.digest()) + SALT_SEPARATOR + salt;
    }

    private static void ensureDigestInitialized() {
        if (digest != null) {
            return;
        }
        try {
            digest = MessageDigest.getInstance(HASHING_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Each Java should come with SHA-256 installed!", e);
        }
    }

    private static String generateSalt() {
        return HashedStoredPasswordAuthenticator.generateSalt(32);
    }

    private HashedPasswordOptionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

