/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.permissions.BasicPermissions;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ProjectPermissions;
import com.teamscale.core.permissions.ProjectSubject;
import com.teamscale.core.permissions.RoleSchema;
import com.teamscale.core.permissions.SubjectRoleAssignments;
import com.teamscale.core.permissions.UserPermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EConfigurationFeature;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class UserPermissionsProvider {
    private final UserGroupIndex groupIndex;
    private final PermissionIndex permissionIndex;
    private final SynchronizedCacheAccess<PermissionCache> permissionCacheAccess;

    public UserPermissionsProvider(UserGroupIndex groupIndex, PermissionIndex permissionIndex, SynchronizedCacheAccess<PermissionCache> permissionCacheAccess) {
        this.groupIndex = groupIndex;
        this.permissionIndex = permissionIndex;
        this.permissionCacheAccess = permissionCacheAccess;
    }

    private static void addPermissionsFromRoleAssignments(UserPermissions userPermissions, SubjectRoleAssignments roleAssignments, RoleSchema roleSchema) {
        ProjectPermissions projectPermissions = userPermissions.getProjectPermissions();
        roleAssignments.getGlobalRoleNames().forEach(roleName -> userPermissions.addGlobalPermissions(roleSchema.getGlobalRole((String)roleName)));
        roleAssignments.getGlobalProjectRoles().forEach(roleName -> projectPermissions.addGlobalProjectPermissions(roleSchema.getProjectRole((String)roleName)));
        roleAssignments.getProjectRoles().forEach((projectId, roleNames) -> roleNames.forEach(roleName -> projectPermissions.addProjectPermission((IProjectId)projectId, roleSchema.getProjectRole((String)roleName))));
        BasicPermissions basicPermissions = userPermissions.getBasicPermissions();
        for (EBasicPermissionScope permissionScope : EBasicPermissionScope.values()) {
            roleAssignments.getGlobalBasicRoles(permissionScope).forEach(roleName -> basicPermissions.addGlobalBasicPermission(permissionScope, roleSchema.getBasicRole((String)roleName)));
            roleAssignments.getBasicRoles(permissionScope).forEach((instanceId, roleNames) -> roleNames.forEach(roleName -> basicPermissions.addBasicPermission(permissionScope, (String)instanceId, roleSchema.getBasicRole((String)roleName))));
        }
    }

    public UserPermissions getUserPermissions(User user) throws StorageException {
        if (user == null) {
            return new UserPermissions();
        }
        return (UserPermissions)this.permissionCacheAccess.getOrUpdate(permissionCache -> permissionCache.getOrUpdateUserPermissions(user, (FunctionWithException<? super User, UserPermissions, StorageException>)((FunctionWithException)this::calcluateUserPermissions)));
    }

    private @NonNull UserPermissions calcluateUserPermissions(User user) throws StorageException {
        List<UserGroup> groups = this.groupIndex.getGroupsForUser(user);
        ArrayList<Serializable> subjects = new ArrayList<Serializable>(groups.size() + 1);
        subjects.addAll(groups);
        subjects.add(user);
        UserPermissions newUserPermissions = new UserPermissions(user);
        RoleSchema roleSchema = this.permissionIndex.getRoleSchema();
        this.permissionIndex.getSubjectRoleAssignments(subjects).forEach(roleAssignment -> UserPermissionsProvider.addPermissionsFromRoleAssignments(newUserPermissions, roleAssignment, roleSchema));
        List<ProjectSubject> projects = newUserPermissions.getProjectPermissions().getVisibleProjectIds().stream().map(ProjectSubject::new).toList();
        this.permissionIndex.getSubjectRoleAssignments(projects).forEach(roleAssignment -> UserPermissionsProvider.addPermissionsFromRoleAssignments(newUserPermissions, roleAssignment, roleSchema));
        UserPermissionsProvider.addConfigurationFeatures(newUserPermissions);
        UserPermissionsProvider.addAccessToOwnUserAndGroups(user, groups, newUserPermissions);
        this.addPermissionsForUsersViaGroup(newUserPermissions);
        return newUserPermissions;
    }

    private void addPermissionsForUsersViaGroup(UserPermissions newUserPermissions) throws StorageException {
        BasicPermissions basicPermissions = newUserPermissions.getBasicPermissions();
        Set<EBasicPermission> globalGroupPermissions = basicPermissions.getGlobalBasicPermissions(EBasicPermissionScope.GROUPS);
        basicPermissions.addGlobalBasicPermissions(EBasicPermissionScope.USERS, globalGroupPermissions);
        Map<String, Set<EBasicPermission>> groupSpecificPermissions = basicPermissions.getBasicPermissionLookup(EBasicPermissionScope.GROUPS).getInstanceSpecificPermissions();
        List<UserGroup> groups = this.groupIndex.getUserGroups(new ArrayList<String>(groupSpecificPermissions.keySet()));
        for (UserGroup group : groups) {
            if (group == null) continue;
            Set<EBasicPermission> permissions = groupSpecificPermissions.get(group.getName());
            for (String userName : group.getUserNames()) {
                for (EBasicPermission basicPermission : permissions) {
                    basicPermissions.addBasicPermission(EBasicPermissionScope.USERS, userName, basicPermission);
                }
            }
        }
    }

    private static void addConfigurationFeatures(UserPermissions userPermissions) {
        ProjectPermissions projectPermissions = userPermissions.getProjectPermissions();
        BasicPermissions basicPermissions = userPermissions.getBasicPermissions();
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_PROJECTS) || projectPermissions.hasAnyProjectPermission(EProjectPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_PROJECTS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_ANALYSIS_PROFILES) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.ANALYSIS_PROFILES, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_ANALYSIS_PROFILES);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_METRIC_THRESHOLD_CONFIGURATIONS) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_METRIC_THRESHOLD_CONFIGURATIONS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_GROUPS) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.GROUPS, EBasicPermission.EDIT)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_GROUPS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_USERS) || basicPermissions.currentUserHasViewPermissionOnUsersOtherThanHimself()) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_USERS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_EXTERNAL_TOOL_ACCOUNTS) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_EXTERNAL_CREDENTIALS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_QUALITY_REPORTS) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.REPORTS, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_QUALITY_REPORTS);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_RETROSPECTIVES) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.RETROSPECTIVES, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_RETROSPECTIVES);
        }
        if (projectPermissions.hasAnyProjectPermission(EProjectPermission.RETRIEVE_TEST_SUGGESTIONS)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_TEST_SELECTION);
        }
        if (userPermissions.hasGlobalPermission(EGlobalPermission.CREATE_PROFILER_CONFIGURATIONS) || basicPermissions.hasAnyBasicPermission(EBasicPermissionScope.PROFILER_CONFIGURATIONS, EBasicPermission.VIEW)) {
            userPermissions.addConfigurationFeature(EConfigurationFeature.CONFIGURE_PROFILERS);
        }
    }

    private static void addAccessToOwnUserAndGroups(User user, List<UserGroup> groupsForUser, UserPermissions userPermissions) {
        BasicPermissions basicPermissions = userPermissions.getBasicPermissions();
        basicPermissions.addBasicPermission(EBasicPermissionScope.USERS, user.getUsername(), EBasicPermission.VIEW);
        basicPermissions.addBasicPermission(EBasicPermissionScope.USERS, user.getUsername(), EBasicPermission.EDIT);
        for (UserGroup group : groupsForUser) {
            basicPermissions.addBasicPermission(EBasicPermissionScope.USERS, group.getName(), EBasicPermission.VIEW);
            basicPermissions.addBasicPermission(EBasicPermissionScope.GROUPS, group.getName(), EBasicPermission.VIEW);
            for (String username : group.getUserNames()) {
                basicPermissions.addBasicPermission(EBasicPermissionScope.USERS, username, EBasicPermission.VIEW);
            }
        }
    }
}

