/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.project;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.index.ProjectIndex;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.concurrent.ThreadUtils;

public class DeleteProjectTrigger
extends PrivilegedTriggerBase {
    public static final long INVALIDATION_ANNOUNCE_GRACE_PERIOD = 5000L;

    @Override
    public void execute() throws StorageException {
        InternalProjectId projectId = this.jobDescriptor.getInternalProjectId();
        ProjectIndex projectIndex = this.indexLayer.openProjectIndex();
        projectIndex.removeProject(projectId);
        DeleteProjectTrigger.markProjectAsInvalid(projectId, this.messageBroker);
        this.indexLayer.getRawStorageSystemProvider().removeStorageSystem(projectId.toString());
        this.indexLayer.getStorageCacheProvider().invalidateCaches();
    }

    static void markProjectAsInvalid(InternalProjectId projectId, IMessageBroker messageBroker) {
        messageBroker.sendMessage("project-invalidation", projectId.toString());
        ThreadUtils.sleep((long)5000L);
    }

    @Override
    public int getExecutionOrderIndex() {
        return -2;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PRIORITY_FULLY_ISOLATED;
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }
}

