/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class PeriodicSchedulingData {
    @VisibleForTesting
    long lastPeriodicSchedulingTimestamp = 0L;
    private final Object lastPeriodicSchedulingLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPeriodicSchedulingTicks() {
        long now = System.currentTimeMillis();
        if (this.lastPeriodicSchedulingTimestamp / 1000L == now / 1000L) {
            return Collections.emptyList();
        }
        ArrayList<Integer> ticks = new ArrayList<Integer>();
        Object object = this.lastPeriodicSchedulingLock;
        synchronized (object) {
            if (this.lastPeriodicSchedulingTimestamp <= 0L) {
                this.lastPeriodicSchedulingTimestamp = now - 1L;
            }
            while (this.lastPeriodicSchedulingTimestamp + 1000L <= now) {
                this.lastPeriodicSchedulingTimestamp += 1000L;
                ticks.add((int)(this.lastPeriodicSchedulingTimestamp / 1000L));
            }
            this.lastPeriodicSchedulingTimestamp = now;
            int lastTick = (int)(this.lastPeriodicSchedulingTimestamp / 1000L);
            if (ticks.isEmpty() || lastTick != (Integer)CollectionUtils.getLast(ticks)) {
                ticks.add(lastTick);
            }
        }
        return ticks;
    }

    public void forcePeriodicSchedulingOnNextRun() {
        this.lastPeriodicSchedulingTimestamp = 0L;
    }
}

