/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import eu.cqse.check.framework.core.FindingPropertyList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.SetMap;

public abstract class CheckFindingBuilderBase {
    private final String checkId;
    private final String category;
    private final @Nullable ElementLocation mainLocation;
    private final String message;
    private @Nullable Map<String, Object> findingProperties = null;
    private @Nullable SetMap<String, String> guidelineMapping = null;
    private @Nullable List<ElementLocation> siblingLocations = null;
    private @Nullable List<ElementLocation> secondaryLocations;

    protected CheckFindingBuilderBase(String checkId, String category, String message, ElementLocation location) {
        CCSMAssert.isNotNull((Object)checkId);
        CCSMAssert.isNotNull((Object)category);
        CCSMAssert.isNotNull((Object)message);
        this.checkId = checkId;
        this.category = category;
        this.message = message;
        this.mainLocation = location;
    }

    public void createAndStore() {
        if (this.mainLocation == null) {
            return;
        }
        IndexFinding finding = this.createFinding();
        this.storeFinding(finding);
    }

    protected abstract void storeFinding(IndexFinding var1);

    private @NonNull IndexFinding createFinding() {
        if (this.checkId == null || this.category == null || this.mainLocation == null || this.message == null) {
            CCSMAssert.fail((String)"Can't create finding. Missing mandatory properties.");
        }
        IndexFinding finding = new IndexFinding(this.checkId, this.category, this.message, this.mainLocation);
        if (this.findingProperties != null) {
            finding.addProperties(this.findingProperties);
        }
        if (this.siblingLocations != null) {
            finding.addSiblingLocations(this.siblingLocations);
        }
        if (this.secondaryLocations != null) {
            finding.addSecondaryLocations(this.secondaryLocations);
        }
        finding.setGuidelineMapping(this.guidelineMapping);
        return finding;
    }

    public void setGuidelineMapping(SetMap<String, String> guidelineMapping) {
        this.guidelineMapping = guidelineMapping;
    }

    public CheckFindingBuilderBase addFindingProperties(FindingPropertyList properties) {
        if (properties == null) {
            return this;
        }
        if (this.findingProperties == null) {
            this.findingProperties = new HashMap<String, Object>();
        }
        this.findingProperties.putAll(properties.getPropertyList());
        return this;
    }

    public CheckFindingBuilderBase addSiblingLocations(List<? extends ElementLocation> siblingLocations) {
        if (this.siblingLocations == null) {
            this.siblingLocations = new ArrayList<ElementLocation>();
        }
        this.siblingLocations.addAll(siblingLocations);
        return this;
    }

    public CheckFindingBuilderBase addSecondaryLocations(List<? extends ElementLocation> secondaryLocations) {
        if (this.secondaryLocations == null) {
            this.secondaryLocations = new ArrayList<ElementLocation>();
        }
        this.secondaryLocations.addAll(secondaryLocations);
        return this;
    }
}

