/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ShallowEntityUtils;
import eu.cqse.check.framework.core.SimulinkElementContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ITypeTracker;
import eu.cqse.check.framework.typetracker.TypeTrackerFactory;
import eu.cqse.check.util.clang.ClangTranslationUnitWrapper;
import eu.cqse.check.util.clang.ClangUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;

public class TokenElementContextBase
implements ITokenElementContext,
AutoCloseable {
    private final Map<ECodeViewOption.ETextViewOption, String> textCache = new HashMap<ECodeViewOption.ETextViewOption, String>();
    private final Map<ECodeViewOption, List<IToken>> tokenCache = new HashMap<ECodeViewOption, List<IToken>>();
    private final Map<ECodeViewOption, DocumentRootShallowEntity> rootEntityCache = new HashMap<ECodeViewOption, DocumentRootShallowEntity>();
    private final Map<ECodeViewOption, ITypeResolution> typeResolutionCache = new HashMap<ECodeViewOption, ITypeResolution>();
    protected StringOffsetTransformer offsetTransformer;
    protected LineOffsetConverter unfilteredLineOffsetConverter;
    protected LineOffsetConverter filteredLineOffsetConverter;
    private ClangTranslationUnitWrapper clangTranslationUnitWrapper;
    private final SimulinkElementContext simulinkContext = new SimulinkElementContext();
    private List<IFileMetadata> fileMetadata;
    private FunctionWithException<UniformPath, TeamscaleIssue, CheckException> workItemAccessor;
    private String uniformPath;
    private ELanguage language;
    private List<PreprocessorTokenReplacement> preprocessorExpansions;

    public void reset(String uniformPath, ELanguage language, UnmodifiableList<Deletion> filterDeletions, String unfilteredText, List<IToken> filteredPreprocessedTokens, UnmodifiableList<ShallowEntity> entitiesWithPreprocessorTokens) {
        CCSMAssert.isNotNull((Object)uniformPath);
        CCSMAssert.isNotNull((Object)language);
        CCSMAssert.isNotNull(filterDeletions);
        CCSMAssert.isNotNull((Object)unfilteredText);
        this.dispose();
        this.uniformPath = uniformPath;
        this.language = language;
        this.offsetTransformer = new StringOffsetTransformer(filterDeletions);
        this.textCache.put(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT, unfilteredText);
        this.textCache.put(ECodeViewOption.ETextViewOption.FILTERED_CONTENT, this.offsetTransformer.filterString(unfilteredText));
        this.unfilteredLineOffsetConverter = new LineOffsetConverter(unfilteredText);
        this.filteredLineOffsetConverter = new LineOffsetConverter(this.textCache.get((Object)ECodeViewOption.ETextViewOption.FILTERED_CONTENT));
        this.tokenCache.put(ECodeViewOption.FILTERED_PREPROCESSED, filteredPreprocessedTokens);
        if (entitiesWithPreprocessorTokens != null) {
            this.rootEntityCache.put(ECodeViewOption.FILTERED_PREPROCESSED, DocumentRootShallowEntity.wrapWithRoot(UniformPathUtils.getElementName((String)this.uniformPath), entitiesWithPreprocessorTokens));
        }
    }

    public void setSimulinkModel(SimulinkModel simulinkModel) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set simulink model in non-simulink files");
        CCSMAssert.isTrue((this.simulinkContext.simulinkModel == null ? 1 : 0) != 0, (String)"Can't set simulink model twice");
        CCSMAssert.isNotNull((Object)simulinkModel, (String)"Can't store null as simulink model in the context.");
        this.simulinkContext.simulinkModel = simulinkModel;
    }

    public void setSimulinkDataDictionary(SimulinkDataDictionary simulinkDataDictionary) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set simulink data dictionary in non-simulink files");
        CCSMAssert.isTrue((this.simulinkContext.simulinkDataDictionary == null ? 1 : 0) != 0, (String)"Can't set simulink data dictionary twice");
        CCSMAssert.isNotNull((Object)simulinkDataDictionary, (String)"Can't store null as simulink data dictionary in the context.");
        this.simulinkContext.simulinkDataDictionary = simulinkDataDictionary;
    }

    public void setSimulinkOutputDataTypes(SimulinkResolvedDataTypes resolvedDataTypes) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set simulink output data types in non-simulink files");
        CCSMAssert.isTrue((this.simulinkContext.simulinkDataTypes == null ? 1 : 0) != 0, (String)"Can't set simulink output data types twice");
        this.simulinkContext.simulinkDataTypes = resolvedDataTypes;
    }

    public void setSimulinkDimensions(SimulinkResolvedDimensions dimensions) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set simulink dimensions in non-simulink files");
        CCSMAssert.isTrue((this.simulinkContext.simulinkDimensions == null ? 1 : 0) != 0, (String)"Can't set simulink dimensions twice");
        this.simulinkContext.simulinkDimensions = dimensions;
    }

    public void setSimulinkSignalLabels(SimulinkPropagatedSignalLabels signalLabels) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set simulink signal labels in non-simulink files");
        CCSMAssert.isTrue((this.simulinkContext.simulinkSignalLabels == null ? 1 : 0) != 0, (String)"Can't set simulink signal labels twice");
        this.simulinkContext.simulinkSignalLabels = signalLabels;
    }

    public void setReferencedSimulinkDataDictionaries(List<SimulinkDataDictionary> dictionaries) {
        CCSMAssert.isTrue((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (String)"Can't set referenced simulink data dictionary in non-simulink files");
        CCSMAssert.isTrue((boolean)this.simulinkContext.referencedSimulinkDataDictionaries.isEmpty(), (String)"Can't set referenced simulink data dictionaries twice");
        this.simulinkContext.referencedSimulinkDataDictionaries.addAll(dictionaries);
    }

    public void setFileMetadata(List<IFileMetadata> fileMetadata) {
        this.fileMetadata = fileMetadata;
    }

    public void setWorkItemAccessor(FunctionWithException<UniformPath, TeamscaleIssue, CheckException> workItemAccessor) {
        CCSMAssert.isTrue((boolean)WiaUtils.isWiaEnabledLanguage((ELanguage)this.language), (String)"Can't set work item accessor in non-work-item analysis");
        CCSMAssert.isTrue((this.workItemAccessor == null ? 1 : 0) != 0, (String)"Can't set work item accessor twice");
        CCSMAssert.isNotNull(workItemAccessor, () -> String.format("Expected \"%s\" to be not null", "workItemAccessor"));
        this.workItemAccessor = workItemAccessor;
    }

    public boolean hasWorkItemAccessor() {
        return this.workItemAccessor != null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    protected void dispose() {
        this.textCache.clear();
        this.tokenCache.clear();
        this.rootEntityCache.clear();
        this.typeResolutionCache.clear();
        this.simulinkContext.referencedSimulinkDataDictionaries.clear();
        this.simulinkContext.simulinkModel = null;
        this.simulinkContext.simulinkDataDictionary = null;
        this.simulinkContext.simulinkDataTypes = null;
        this.simulinkContext.simulinkDimensions = null;
        this.simulinkContext.simulinkSignalLabels = null;
        if (this.clangTranslationUnitWrapper != null) {
            this.clangTranslationUnitWrapper.dispose();
            this.clangTranslationUnitWrapper = null;
        }
        this.workItemAccessor = null;
    }

    @Override
    public ELanguage getLanguage() {
        return this.language;
    }

    @Override
    public String getUniformPath() {
        return this.uniformPath;
    }

    public String getCheckId() {
        return "phase";
    }

    @Override
    public SimulinkElementContext getSimulinkContext() {
        return this.simulinkContext;
    }

    @Override
    public List<IToken> getTokens(ECodeViewOption view) {
        List<IToken> tokens = this.tokenCache.get((Object)view);
        if (tokens == null) {
            tokens = this.computeTokens(view);
        }
        CCSMAssert.isNotNull(tokens, (String)("Could not compute " + String.valueOf((Object)view) + " tokens for file " + this.uniformPath));
        return tokens;
    }

    private List<IToken> computeTokens(ECodeViewOption view) {
        switch (view) {
            case UNFILTERED: {
                this.tokenCache.put(ECodeViewOption.UNFILTERED, ScannerUtils.getTokens(this.getTextContent(ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT), this.language, this.getUniformPath()));
                return this.tokenCache.get((Object)ECodeViewOption.UNFILTERED);
            }
            case FILTERED: {
                if (PreprocessorUtils.hasPreprocessor(this.language)) {
                    this.tokenCache.put(ECodeViewOption.FILTERED, ScannerUtils.getTokens(this.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT), this.language, this.uniformPath));
                } else {
                    this.tokenCache.put(ECodeViewOption.FILTERED, this.tokenCache.get((Object)ECodeViewOption.FILTERED_PREPROCESSED));
                }
                return this.tokenCache.get((Object)ECodeViewOption.FILTERED);
            }
            case FILTERED_PREPROCESSED: {
                CCSMAssert.fail((String)"Filtered/Preprocessed tokens must be set on class initialization");
                return null;
            }
            case UNFILTERED_PREPROCESSED: {
                this.tokenCache.put(ECodeViewOption.UNFILTERED_PREPROCESSED, this.calculateLocalPreprocessedTokens(this.getTokens(ECodeViewOption.UNFILTERED)));
                return this.tokenCache.get((Object)ECodeViewOption.UNFILTERED_PREPROCESSED);
            }
        }
        throw new AssertionError((Object)("Missing case for " + String.valueOf((Object)view)));
    }

    @Override
    public String getTextContent(ECodeViewOption.ETextViewOption view) {
        String text = this.textCache.get((Object)view);
        CCSMAssert.isNotNull((Object)text, (String)("Could not get " + String.valueOf((Object)view) + " text for file " + this.uniformPath));
        return text;
    }

    @Override
    public DocumentRootShallowEntity getRootEntity(ECodeViewOption view) {
        DocumentRootShallowEntity rootEntity = this.rootEntityCache.get((Object)view);
        if (rootEntity != null) {
            return rootEntity;
        }
        switch (view) {
            case UNFILTERED_PREPROCESSED: {
                this.initializeUnfilteredPreprocessedRootEntity();
                break;
            }
            case FILTERED: {
                this.initializeFilteredRootEntityWithoutPreprocessorTokens();
                break;
            }
            case FILTERED_PREPROCESSED: {
                break;
            }
            default: {
                throw new AssertionError((Object)("The ECodeViewOption " + String.valueOf((Object)view) + " is not supported."));
            }
        }
        rootEntity = this.rootEntityCache.get((Object)view);
        CCSMAssert.isNotNull((Object)((Object)rootEntity), (String)("Could not load AST " + String.valueOf((Object)view) + " for file " + this.uniformPath + ". Check that  ECheckParameter.ABSTRACT_SYNTAX_TREE  has been set as parameter for the check " + this.getCheckId()));
        return rootEntity;
    }

    private void initializeFilteredRootEntityWithoutPreprocessorTokens() {
        UnmodifiableList filteredPreprocessedEntities = this.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren();
        List<ShallowEntity> filteredEntitiesWithoutPreprocessorTokens = PreprocessorUtils.hasPreprocessor(this.language) ? ShallowEntityUtils.filterCPreprocessorTokens((List<ShallowEntity>)filteredPreprocessedEntities) : ShallowEntityUtils.cloneShallowEntities((List<ShallowEntity>)filteredPreprocessedEntities);
        this.rootEntityCache.put(ECodeViewOption.FILTERED, DocumentRootShallowEntity.wrapWithRoot(this.uniformPath, filteredEntitiesWithoutPreprocessorTokens));
    }

    private void initializeUnfilteredPreprocessedRootEntity() {
        List<IToken> unfilteredPreprocessedTokens = this.getTokens(ECodeViewOption.UNFILTERED_PREPROCESSED);
        if (ShallowParserFactory.supportsLanguage(this.language)) {
            try {
                this.rootEntityCache.put(ECodeViewOption.UNFILTERED_PREPROCESSED, DocumentRootShallowEntity.wrapWithRoot(this.uniformPath, ShallowParserFactory.createParser(this.language).parseTopLevel(unfilteredPreprocessedTokens)));
            }
            catch (ShallowParserException e) {
                throw new AssertionError("Can not happen as we checked for the language before!", e);
            }
        }
    }

    @Override
    public List<ShallowEntity> getAbstractSyntaxTree(ECodeViewOption view) {
        DocumentRootShallowEntity rootEntity = this.getRootEntity(view);
        CCSMAssert.isNotNull((Object)((Object)rootEntity));
        return rootEntity.getChildren();
    }

    @Override
    public ITypeResolution getTypeResolution(ECodeViewOption view) {
        CCSMAssert.isTrue((boolean)TypeTrackerFactory.supportsLanguage(this.language), (String)("Can't generate type resolution for language " + String.valueOf(this.language) + " in file " + this.uniformPath));
        ITypeResolution typeResolution = this.typeResolutionCache.get((Object)view);
        if (typeResolution == null) {
            ITypeTracker tracker = TypeTrackerFactory.createTypeTracker(this.language);
            typeResolution = tracker.createTypeResolution(this.getAbstractSyntaxTree(view));
            this.typeResolutionCache.put(view, typeResolution);
        }
        return typeResolution;
    }

    public void ensureClangTranslationUnitWrapperInitialized() throws ConQATException {
        if (this.clangTranslationUnitWrapper == null && ClangUtils.CLANG_ENABLED_LANGUAGES.contains(this.language)) {
            this.clangTranslationUnitWrapper = ClangTranslationUnitWrapper.createForContext(this);
        } else if (!ClangUtils.CLANG_ENABLED_LANGUAGES.contains(this.language)) {
            CCSMAssert.fail((String)("Clang parser is not supported for language " + String.valueOf(this.language) + " of " + this.uniformPath));
        }
    }

    @Override
    public ClangTranslationUnitWrapper getClangTranslationUnitWrapper() {
        if (this.clangTranslationUnitWrapper == null) {
            CCSMAssert.fail((String)"Clang not initialized for this instance.");
        }
        return this.clangTranslationUnitWrapper;
    }

    public boolean clangTranslationUnitWrapperIsInitialized() {
        return this.clangTranslationUnitWrapper != null;
    }

    @Override
    public List<IFileMetadata> getAllMetadataForCurrentFile() {
        if (this.fileMetadata != null) {
            return this.fileMetadata;
        }
        return CollectionUtils.emptyList();
    }

    @Override
    public <T extends IFileMetadata> Optional<T> getMetadataOfType(Class<T> metadataClass) {
        if (this.fileMetadata == null || this.fileMetadata.isEmpty()) {
            return Optional.empty();
        }
        return this.fileMetadata.stream().filter(metadataClass::isInstance).map(metadataClass::cast).findFirst();
    }

    @Override
    public Optional<TeamscaleIssue> getWorkItemForUniformPath(UniformPath uniformPath) throws CheckException {
        if (this.workItemAccessor == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((TeamscaleIssue)this.workItemAccessor.apply((Object)uniformPath));
    }

    public void setPreprocessorExpansions(List<PreprocessorTokenReplacement> expansions) {
        this.preprocessorExpansions = expansions;
    }

    @Override
    public List<PreprocessorTokenReplacement> getPreprocessorExpansions() {
        return this.preprocessorExpansions;
    }
}

