/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.core.EFindingEnablement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;

public class CheckMapping {
    public static final String TSV_FILE_HEADER_EXPANDED = "ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement\tComments\tUpstream URL";
    public static final String TSV_FILE_HEADER = "ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement";
    public final String checkId;
    private final String readableCheckName;
    public final String category;
    public final String group;
    public final @Nullable EFindingEnablement defaultEnablement;
    public final @Nullable String comments;
    public final @Nullable String upstreamURL;
    public final boolean autoAllowed;
    public static final String IGNORED_ENABLEMENT = "IGNORED";

    public CheckMapping(String checkId, String readableCheckName, String category, String group, @Nullable EFindingEnablement defaultEnablement) {
        this(checkId, readableCheckName, category, group, defaultEnablement, "", "", false);
    }

    public CheckMapping(String checkId, String readableCheckName, String category, String group, @Nullable EFindingEnablement defaultEnablement, @Nullable String comments, @Nullable String upstreamURL, boolean autoAllowed) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)checkId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isEmpty((String)readableCheckName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isEmpty((String)category) ? 1 : 0) != 0);
        Preconditions.checkArgument((!StringUtils.isEmpty((String)group) ? 1 : 0) != 0);
        this.checkId = checkId;
        this.readableCheckName = readableCheckName;
        this.category = category;
        this.group = group;
        this.defaultEnablement = defaultEnablement;
        this.comments = comments;
        this.upstreamURL = upstreamURL;
        this.autoAllowed = autoAllowed;
    }

    public CheckMapping(CheckMapping other, String category, String group, @Nullable EFindingEnablement defaultEnablement) {
        this.checkId = other.checkId;
        this.readableCheckName = other.readableCheckName;
        this.category = category;
        this.group = group;
        this.defaultEnablement = defaultEnablement;
        this.comments = other.comments;
        this.upstreamURL = other.upstreamURL;
        this.autoAllowed = false;
    }

    public CheckMapping(CheckMapping other, String readableCheckName, String category, String group, @Nullable EFindingEnablement defaultEnablement) {
        this.checkId = other.checkId;
        this.readableCheckName = readableCheckName;
        this.category = category;
        this.group = group;
        this.defaultEnablement = defaultEnablement;
        this.comments = other.comments;
        this.upstreamURL = other.upstreamURL;
        this.autoAllowed = false;
    }

    public String getReadableCheckName() {
        return this.readableCheckName;
    }

    public String toString() {
        return "CheckMapping{checkId='" + this.checkId + "', readableCheckName='" + this.readableCheckName + "', category='" + this.category + "', group='" + this.group + "', defaultEnablement=" + String.valueOf((Object)this.defaultEnablement) + ", comments='" + this.comments + "', upstreamURL='" + this.upstreamURL + "', autoAllowed=" + this.autoAllowed + "}";
    }
}

