/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TokenStreamTextUtils {
    public static int findFirst(List<IToken> tokens, String text) {
        return TokenStreamTextUtils.findFirst(tokens, 0, tokens.size(), Collections.singleton(text));
    }

    public static int findFirst(List<IToken> tokens, Set<String> texts) {
        return TokenStreamTextUtils.findFirst(tokens, 0, tokens.size(), texts);
    }

    public static int findFirst(List<IToken> tokens, int startTokenIndex, Set<String> texts) {
        return TokenStreamTextUtils.findFirst(tokens, startTokenIndex, tokens.size(), texts);
    }

    public static int findFirst(List<IToken> tokens, int startTokenIndex, int endTokenIndex, String text) {
        return TokenStreamTextUtils.findFirst(tokens, startTokenIndex, endTokenIndex, Collections.singleton(text));
    }

    public static int findFirst(List<IToken> tokens, int startTokenIndex, int endTokenIndex, Set<String> texts) {
        int exclusiveUpperBoundTokenIndex = Math.min(tokens.size(), endTokenIndex);
        for (int i = startTokenIndex; i < exclusiveUpperBoundTokenIndex; ++i) {
            IToken token = tokens.get(i);
            boolean foundMatch = token.getLanguage().isCaseSensitive() ? texts.contains(token.getText()) : texts.stream().anyMatch(text -> text.equalsIgnoreCase(token.getText()));
            if (!foundMatch) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> findAll(List<IToken> tokens, String text) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (!tokens.get(i).getText().equals(text)) continue;
            indices.add(i);
        }
        return indices;
    }

    public static List<Integer> findAll(List<IToken> tokens, Set<String> texts, int startTokenIndex, int endTokenIndex) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int exclusiveUpperBoundTokenIndex = Math.min(tokens.size(), endTokenIndex);
        for (int i = startTokenIndex; i < exclusiveUpperBoundTokenIndex; ++i) {
            if (!texts.contains(tokens.get(i).getText())) continue;
            indices.add(i);
        }
        return indices;
    }

    public static boolean contains(List<IToken> tokens, String text) {
        return TokenStreamTextUtils.findFirst(tokens, text) != -1;
    }

    public static boolean containsAny(List<IToken> tokens, Set<String> texts) {
        return TokenStreamTextUtils.findFirst(tokens, texts) != -1;
    }

    public static boolean hasSequence(List<IToken> tokens, int startTokenIndex, String ... sequence) {
        return TokenStreamTextUtils.hasSequence(tokens, startTokenIndex, true, sequence);
    }

    public static boolean hasSequence(List<IToken> tokens, int startTokenIndex, boolean caseSensitive, String ... sequence) {
        CCSMAssert.isFalse((startTokenIndex < 0 ? 1 : 0) != 0, (String)"startTokenIndex must not be less than zero");
        if (startTokenIndex + sequence.length > tokens.size()) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            String text = tokens.get(startTokenIndex + i).getText();
            if ((!caseSensitive || text.equals(sequence[i])) && (caseSensitive || text.equalsIgnoreCase(sequence[i]))) continue;
            return false;
        }
        return true;
    }

    public static int findSequence(List<IToken> tokens, int startTokenIndex, ETokenType startType, String ... sequence) {
        return TokenStreamTextUtils.findSequence(tokens, startTokenIndex, startType, true, sequence);
    }

    private static int findSequence(List<IToken> tokens, int startTokenIndex, ETokenType startType, boolean caseSensitive, String ... sequence) {
        for (int i = startTokenIndex; i < tokens.size() - sequence.length + 1; ++i) {
            if (tokens.get(i).getType() != startType || !TokenStreamTextUtils.hasSequence(tokens, i, caseSensitive, sequence)) continue;
            return i;
        }
        return -1;
    }

    public static int findSequence(List<IToken> tokens, boolean caseSensitive, String ... sequence) {
        for (int i = 0; i < tokens.size() - sequence.length + 1; ++i) {
            if (!TokenStreamTextUtils.hasSequence(tokens, i, caseSensitive, sequence)) continue;
            return i;
        }
        return -1;
    }

    public static int findSequence(List<IToken> tokens, String ... sequence) {
        return TokenStreamTextUtils.findSequence(tokens, true, sequence);
    }

    public static List<Integer> findAllSequences(List<IToken> tokens, int startTokenIndex, ETokenType startType, String ... sequence) {
        return TokenStreamTextUtils.findAllSequences(tokens, startTokenIndex, startType, true, sequence);
    }

    public static List<Integer> findAllSequences(List<IToken> tokens, int startTokenIndex, ETokenType startType, boolean caseSensitive, String ... sequence) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        while (startTokenIndex < tokens.size() - sequence.length + 1 && (startTokenIndex = TokenStreamTextUtils.findSequence(tokens, startTokenIndex, startType, caseSensitive, sequence)) != -1) {
            indices.add(startTokenIndex);
            ++startTokenIndex;
        }
        return indices;
    }

    public static String concatTokenTexts(List<IToken> tokens) {
        return TokenStreamTextUtils.concatTokenTexts(tokens, "");
    }

    public static String concatTokenTexts(List<IToken> tokens, String separator) {
        return StringUtils.concat((Iterable)CollectionUtils.map(tokens, IToken::getText), (String)separator);
    }

    public static List<String> concatAllTokenTexts(List<List<IToken>> tokenLists) {
        return CollectionUtils.map(tokenLists, TokenStreamTextUtils::concatTokenTexts);
    }

    public static List<String> getTokenTexts(List<IToken> tokens, int startTokenIndex, int endTokenIndex) {
        CCSMAssert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0, (String)"startTokenIndex must be greater or equal to zero");
        CCSMAssert.isTrue((endTokenIndex <= tokens.size() ? 1 : 0) != 0, (String)"endTokenIndex must be less or equal to tokens.size()");
        return CollectionUtils.map(tokens.subList(startTokenIndex, endTokenIndex), IToken::getText);
    }

    public static List<String> getTokenTexts(List<IToken> tokens) {
        return TokenStreamTextUtils.getTokenTexts(tokens, 0, tokens.size());
    }

    public static boolean is(IToken token, ETokenType tokenType, String tokenText) {
        if (token.getType() != tokenType) {
            return false;
        }
        if (token.getLanguage().isCaseSensitive()) {
            return token.getText().equals(tokenText);
        }
        return token.getText().equalsIgnoreCase(tokenText);
    }

    public static boolean tokenExpressionsAreEqual(List<IToken> first, List<IToken> second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).getType() == second.get(i).getType() && first.get(i).getText().equals(second.get(i).getText())) continue;
            return false;
        }
        return true;
    }

    private TokenStreamTextUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

