/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.hanasqlscript;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;

public class HanaSQLScriptShallowParser
extends ShallowParserBase<EHanaSQLScriptParserStates> {
    private static final ITokenMatcher HANA_SQLSCRIPT_IDENTIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ABS, ETokenType.ALL, ETokenType.ALLOCATE, ETokenType.ALTER, ETokenType.AND, ETokenType.ANY, ETokenType.ARE, ETokenType.ARRAY, ETokenType.ARRAY_AGG, ETokenType.ARRAY_MAX_CARDINALITY, ETokenType.AS, ETokenType.ASENSITIVE, ETokenType.ASYMMETRIC, ETokenType.AT, ETokenType.ATOMIC, ETokenType.AUTHORIZATION, ETokenType.AUTO_CORR, ETokenType.AVG, ETokenType.BEGIN, ETokenType.BEGIN_FRAME, ETokenType.BEGIN_PARTITION, ETokenType.BETWEEN, ETokenType.BIGINT, ETokenType.BINARY, ETokenType.BLOB, ETokenType.BOOLEAN, ETokenType.BOTH, ETokenType.BY, ETokenType.CALL, ETokenType.CALLED, ETokenType.CARDINALITY, ETokenType.CASCADED, ETokenType.CASE, ETokenType.CAST, ETokenType.CEIL, ETokenType.CEILING, ETokenType.CHAR, ETokenType.CHAR_LENGTH, ETokenType.CHARACTER, ETokenType.CHARACTER_LENGTH, ETokenType.CHECK, ETokenType.CLASSIFIER, ETokenType.CLOB, ETokenType.CLOSE, ETokenType.COALESCE, ETokenType.COLLATE, ETokenType.COLLECT, ETokenType.COLUMN, ETokenType.COMMIT, ETokenType.CONDITION, ETokenType.CONNECT, ETokenType.CONSTRAINT, ETokenType.CONTAINS, ETokenType.CONVERT, ETokenType.CORR, ETokenType.CORRESPONDING, ETokenType.CORR_SPEARMAN, ETokenType.COUNT, ETokenType.COVAR_POP, ETokenType.COVAR_SAMP, ETokenType.CREATE, ETokenType.CROSS, ETokenType.CROSS_CORR, ETokenType.CUBE, ETokenType.CUME_DIST, ETokenType.CURRENT, ETokenType.CURRENT_CATALOG, ETokenType.CURRENT_DATE, ETokenType.CURRENT_DEFAULT_TRANSFORM_GROUP, ETokenType.CURRENT_PATH, ETokenType.CURRENT_ROLE, ETokenType.CURRENT_ROW, ETokenType.CURRENT_SCHEMA, ETokenType.CURRENT_TIME, ETokenType.CURRENT_TIMESTAMP, ETokenType.CURRENT_TRANSFORM_GROUP_FOR_TYPE, ETokenType.CURRENT_USER, ETokenType.CURSOR, ETokenType.CYCLE, ETokenType.DATE, ETokenType.DAY, ETokenType.DEALLOCATE, ETokenType.DEC, ETokenType.DECIMAL, ETokenType.DECLARE, ETokenType.DEFAULT, ETokenType.DEFINE, ETokenType.DELETE, ETokenType.DENSE_RANK, ETokenType.DEREF, ETokenType.DESCRIBE, ETokenType.DETERMINISTIC, ETokenType.DISCONNECT, ETokenType.DFT, ETokenType.DISTINCT, ETokenType.DOUBLE, ETokenType.DROP, ETokenType.DYNAMIC, ETokenType.EACH, ETokenType.ELEMENT, ETokenType.ELSE, ETokenType.EMPTY, ETokenType.END, ETokenType.END_FRAME, ETokenType.END_PARTITION, ETokenType.EQUALS, ETokenType.ESCAPE, ETokenType.EVERY, ETokenType.EXCEPT, ETokenType.EXEC, ETokenType.EXECUTE, ETokenType.EXISTS, ETokenType.EXP, ETokenType.EXTERNAL, ETokenType.EXTRACT, ETokenType.FALSE, ETokenType.FETCH, ETokenType.FILTER, ETokenType.FIRST_VALUE, ETokenType.FLOAT, ETokenType.FLOOR, ETokenType.FOR, ETokenType.FOREIGN, ETokenType.FRAME_ROW, ETokenType.FREE, ETokenType.FROM, ETokenType.FULL, ETokenType.FUNCTION, ETokenType.FUSION, ETokenType.GET, ETokenType.GLOBAL, ETokenType.GRANT, ETokenType.GROUP, ETokenType.GROUPING, ETokenType.GROUPS, ETokenType.HAVING, ETokenType.HOLD, ETokenType.HOUR, ETokenType.IDENTITY, ETokenType.IN, ETokenType.INDICATOR, ETokenType.INITIAL, ETokenType.INNER, ETokenType.INOUT, ETokenType.INSENSITIVE, ETokenType.INSERT, ETokenType.INT, ETokenType.INTEGER, ETokenType.INTERSECT, ETokenType.INTERSECTION, ETokenType.INTERVAL, ETokenType.INTO, ETokenType.IS, ETokenType.JOIN, ETokenType.LAG, ETokenType.LANGUAGE, ETokenType.LARGE, ETokenType.LAST_VALUE, ETokenType.LATERAL, ETokenType.LEAD, ETokenType.LEADING, ETokenType.LEFT, ETokenType.LIKE, ETokenType.LIKE_REGEX, ETokenType.LN, ETokenType.LOCAL, ETokenType.LOCALTIME, ETokenType.LOCALTIMESTAMP, ETokenType.LOWER, ETokenType.MATCH, ETokenType.MATCH_NUMBER, ETokenType.MATCH_RECOGNIZE, ETokenType.MATCHES, ETokenType.MAX, ETokenType.MEDIAN, ETokenType.MEMBER, ETokenType.MERGE, ETokenType.METHOD, ETokenType.MIN, ETokenType.MINUTE, ETokenType.MOD, ETokenType.MODIFIES, ETokenType.MODULE, ETokenType.MONTH, ETokenType.MULTISET, ETokenType.NATIONAL, ETokenType.NATURAL, ETokenType.NCHAR, ETokenType.NCLOB, ETokenType.NEW, ETokenType.NO, ETokenType.NONE, ETokenType.NORMALIZE, ETokenType.NOT, ETokenType.NTH_VALUE, ETokenType.NTILE, ETokenType.NULL, ETokenType.NULLIF, ETokenType.NUMERIC, ETokenType.OCTET_LENGTH, ETokenType.OCCURRENCES_REGEX, ETokenType.OF, ETokenType.OFFSET, ETokenType.OLD, ETokenType.OMIT, ETokenType.ON, ETokenType.ONE, ETokenType.ONLY, ETokenType.OPEN, ETokenType.OR, ETokenType.ORDER, ETokenType.OUT, ETokenType.OUTER, ETokenType.OVER, ETokenType.OVERLAPS, ETokenType.OVERLAY, ETokenType.PARAMETER, ETokenType.PARTITION, ETokenType.PATTERN, ETokenType.PER, ETokenType.PERCENT, ETokenType.PERCENT_RANK, ETokenType.PERCENTILE_CONT, ETokenType.PERCENTILE_DISC, ETokenType.PERIOD, ETokenType.PORTION, ETokenType.POSITION, ETokenType.POSITION_REGEX, ETokenType.POWER, ETokenType.PRECEDES, ETokenType.PRECISION, ETokenType.PREPARE, ETokenType.PRIMARY, ETokenType.PROCEDURE, ETokenType.RANGE, ETokenType.RANK, ETokenType.READS, ETokenType.REAL, ETokenType.RECOVER, ETokenType.RECURSIVE, ETokenType.REF, ETokenType.REFERENCES, ETokenType.REFERENCING, ETokenType.REGR_AVGX, ETokenType.REGR_AVGY, ETokenType.REGR_COUNT, ETokenType.REGR_INTERCEPT, ETokenType.REGR_R2, ETokenType.REGR_SLOPE, ETokenType.REGR_SXX, ETokenType.REGR_SXY, ETokenType.REGR_SYY, ETokenType.RELEASE, ETokenType.RESULT, ETokenType.RETURN, ETokenType.RETURNS, ETokenType.REVOKE, ETokenType.RIGHT, ETokenType.ROLLBACK, ETokenType.ROLLUP, ETokenType.ROW, ETokenType.ROW_NUMBER, ETokenType.ROWS, ETokenType.RUNNING, ETokenType.SAVEPOINT, ETokenType.SCOPE, ETokenType.SCROLL, ETokenType.SEARCH, ETokenType.SECOND, ETokenType.SEEK, ETokenType.SELECT, ETokenType.SENSITIVE, ETokenType.SESSION_USER, ETokenType.SET, ETokenType.SHOW, ETokenType.SKIP, ETokenType.SIMILAR, ETokenType.SMALLINT, ETokenType.SOME, ETokenType.SPECIFIC, ETokenType.SPECIFICTYPE, ETokenType.SQL, ETokenType.SQLEXCEPTION, ETokenType.SQLSTATE, ETokenType.SQLWARNING, ETokenType.SQRT, ETokenType.START, ETokenType.STATIC, ETokenType.STDDEV, ETokenType.STDDEV_POP, ETokenType.STDDEV_SAMP, ETokenType.STRING_AGG, ETokenType.SUBMULTISET, ETokenType.SUBSET, ETokenType.SUBSTRING, ETokenType.SUBSTRING_REGEX, ETokenType.SUCCEEDS, ETokenType.SUM, ETokenType.SYMMETRIC, ETokenType.SYSTEM, ETokenType.SYSTEM_TIME, ETokenType.SYSTEM_USER, ETokenType.TABLE, ETokenType.TABLESAMPLE, ETokenType.THEN, ETokenType.TIME, ETokenType.TIMESTAMP, ETokenType.TIMEZONE_HOUR, ETokenType.TIMEZONE_MINUTE, ETokenType.TO, ETokenType.TRAILING, ETokenType.TRANSLATE, ETokenType.TRANSLATE_REGEX, ETokenType.TRANSLATION, ETokenType.TREAT, ETokenType.TRIGGER, ETokenType.TRUNCATE, ETokenType.TRIM, ETokenType.TRIM_ARRAY, ETokenType.TRUE, ETokenType.UESCAPE, ETokenType.UNION, ETokenType.UNIQUE, ETokenType.UNKNOWN, ETokenType.UNLOAD, ETokenType.UNNEST, ETokenType.UPDATE, ETokenType.UPPER, ETokenType.UPSERT, ETokenType.USER, ETokenType.USING, ETokenType.VALUE, ETokenType.VALUES, ETokenType.VALUE_OF, ETokenType.VAR, ETokenType.VAR_POP, ETokenType.VAR_SAMP, ETokenType.VARBINARY, ETokenType.VARCHAR, ETokenType.VARYING, ETokenType.VERSIONING, ETokenType.WHEN, ETokenType.WHENEVER, ETokenType.WHERE, ETokenType.WIDTH_BUCKET, ETokenType.WINDOW, ETokenType.WITH, ETokenType.WITHIN, ETokenType.WITHOUT, ETokenType.YEAR});

    public HanaSQLScriptShallowParser() {
        super(EHanaSQLScriptParserStates.class, EHanaSQLScriptParserStates.OUTSIDE_METHODS);
        this.createMetaRules();
        this.createMethodRules();
        this.createStatementRules();
    }

    private void createMetaRules() {
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.OUTSIDE_METHODS}).sequence(new ITokenMatcher[]{ETokenType.SET, ETokenType.HISTORY, ETokenType.SESSION, ETokenType.TO}).createNode(EShallowEntityType.META, "set", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase otherSetStatementsMatch = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.OUTSIDE_METHODS}).sequence(new ITokenMatcher[]{ETokenType.SET, HANA_SQLSCRIPT_IDENTIFIERS});
        RecognizerBase sessionVarMatch = otherSetStatementsMatch.repeated(HANA_SQLSCRIPT_IDENTIFIERS).sequence(new ITokenMatcher[]{ETokenType.EQUAL}).createNode(EShallowEntityType.ATTRIBUTE, "session variable", INameResolver.secondMatchedTokenText());
        sessionVarMatch.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase schemaAndOtherMatch = otherSetStatementsMatch.repeated(HANA_SQLSCRIPT_IDENTIFIERS).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.META, "set", INameResolver.secondMatchedTokenText());
        schemaAndOtherMatch.endNode();
        this.createRulesForSQLStatements();
    }

    private void createRulesForSQLStatements() {
        this.inAnyState().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ALTER, ETokenType.COMMIT, ETokenType.DELETE, ETokenType.GRANT, ETokenType.LOCK, ETokenType.ROLLBACK, ETokenType.SAVEPOINT, ETokenType.SELECT, ETokenType.DROP, ETokenType.MERGE, ETokenType.UPDATE, ETokenType.TRUNCATE, ETokenType.REVOKE, ETokenType.RENAME, ETokenType.LOAD, ETokenType.IMPORT, ETokenType.EXPORT, ETokenType.UPSERT, ETokenType.REPLACE, ETokenType.UNLOAD, ETokenType.BACKUP, ETokenType.RECOVER})).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase<EHanaSQLScriptParserStates> insertMatch = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.INSERT, ETokenType.INTO}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        RecognizerBase<EHanaSQLScriptParserStates> matchInsertTableName = HanaSQLScriptShallowParser.matchTableNameForRule(insertMatch);
        matchInsertTableName.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SET, ETokenType.TRANSACTION}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.createRuleForSQLCreate();
    }

    private void createRuleForSQLCreate() {
        RecognizerBase createMatch = this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.CREATE});
        createMatch.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FULLTEXT, ETokenType.GRAPH, ETokenType.SCHEMA, ETokenType.SEQUENCE, ETokenType.STATISTICS, ETokenType.VIEW})).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        createMatch.optional(new ITokenMatcher[]{ETokenType.PUBLIC}).sequence(new ITokenMatcher[]{ETokenType.SYNONYM}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        createMatch.optional(new ITokenMatcher[]{ETokenType.UNIQUE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BTREE, ETokenType.CPBTREE})).sequence(new ITokenMatcher[]{ETokenType.INDEX}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        HanaSQLScriptShallowParser.completeCreateTableRule(createMatch.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VIRTUAL, ETokenType.ROW, ETokenType.COLUMN})));
        HanaSQLScriptShallowParser.completeCreateTableRule(createMatch.optional(new ITokenMatcher[]{ETokenType.HISTORY, ETokenType.COLUMN}));
        HanaSQLScriptShallowParser.completeCreateTableRule(createMatch.optional(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LOCAL, ETokenType.GLOBAL}), ETokenType.TEMPORARY}).optional(new ITokenMatcher[]{ETokenType.COLUMN}));
    }

    private static void completeCreateTableRule(RecognizerBase<EHanaSQLScriptParserStates> state) {
        RecognizerBase<EHanaSQLScriptParserStates> matchTable = state.sequence(new ITokenMatcher[]{ETokenType.TABLE}).createNode(EShallowEntityType.STATEMENT, "SQL", INameResolver.firstMatchedTokenText());
        RecognizerBase<EHanaSQLScriptParserStates> matchTableName = HanaSQLScriptShallowParser.matchTableNameForRule(matchTable);
        matchTableName.skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static RecognizerBase<EHanaSQLScriptParserStates> matchTableNameForRule(RecognizerBase<EHanaSQLScriptParserStates> state) {
        return state.optional(new ITokenMatcher[]{ETokenType.HASH}).repeated(new ITokenMatcher[]{HANA_SQLSCRIPT_IDENTIFIERS, ETokenType.DOT}).sequence(HANA_SQLSCRIPT_IDENTIFIERS);
    }

    private void createMethodRules() {
        RecognizerBase methodStart = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.OUTSIDE_METHODS}).optional(new ITokenMatcher[]{ETokenType.CREATE}).markStart().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FUNCTION, ETokenType.PROCEDURE, ETokenType.TRIGGER})).repeated(new ITokenMatcher[]{HANA_SQLSCRIPT_IDENTIFIERS, ETokenType.DOT}).sequence(HANA_SQLSCRIPT_IDENTIFIERS).createNode(EShallowEntityType.METHOD, INameResolver.firstMatchedTokenText(), INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EHanaSQLScriptParserStates> triggerMatch = methodStart.skipAfter(new ITokenMatcher[]{ETokenType.ON}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipBefore(new ITokenMatcher[]{ETokenType.BEGIN});
        HanaSQLScriptShallowParser.completeMethodMatch(triggerMatch);
        RecognizerBase<EHanaSQLScriptParserStates> functionsAndProcsMatch = methodStart.skipBefore(new ITokenMatcher[]{ETokenType.AS}).skipBefore(new ITokenMatcher[]{ETokenType.BEGIN}).optional(new ITokenMatcher[]{ETokenType.SEQUENTIAL, ETokenType.EXECUTION});
        HanaSQLScriptShallowParser.completeMethodMatch(functionsAndProcsMatch);
    }

    private static void completeMethodMatch(RecognizerBase<EHanaSQLScriptParserStates> match) {
        match.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createStatementRules() {
        this.createRulesForVariablesConstants();
        this.createRulesForIfElse();
        this.createRulesForCaseElse();
        RecognizerBase blockHeadMatch = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "block", INameResolver.firstMatchedTokenText());
        HanaSQLScriptShallowParser.completeAnonymousBlockMatch(blockHeadMatch.optional(new ITokenMatcher[]{ETokenType.AUTONOMOUS, ETokenType.TRANSACTION}));
        HanaSQLScriptShallowParser.completeAnonymousBlockMatch(blockHeadMatch.optional(new ITokenMatcher[]{ETokenType.PARALLEL, ETokenType.EXECUTION}));
        this.createRuleForLoops((ITokenMatcher)ETokenType.WHILE, new ITokenMatcher[]{ETokenType.WHILE});
        this.createRuleForLoops((ITokenMatcher)ETokenType.FOR, new ITokenMatcher[]{ETokenType.FOR, ETokenType.IDENTIFIER, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IN, ETokenType.AS})});
        ITokenMatcher assignmentOperators = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQUAL, ETokenType.ASSIGNMENT});
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).repeated(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.LEFT_LABEL_BRACKET}).skipBefore(assignmentOperators).sequence(assignmentOperators).createNode(EShallowEntityType.STATEMENT, "assignment", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CALL}).repeated(new ITokenMatcher[]{HANA_SQLSCRIPT_IDENTIFIERS, ETokenType.DOT}).markStart().sequence(new ITokenMatcher[]{HANA_SQLSCRIPT_IDENTIFIERS, ETokenType.LPAREN}).skipAfter(new ITokenMatcher[]{ETokenType.RPAREN}).createNode(EShallowEntityType.STATEMENT, "procedure call", INameResolver.firstMatchedTokenText()).endNode();
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EXEC, ETokenType.SIGNAL, ETokenType.RESIGNAL, ETokenType.OPEN, ETokenType.CLOSE, ETokenType.BREAK, ETokenType.FETCH, ETokenType.CONTINUE, ETokenType.EXECUTE, ETokenType.RETURN})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void completeAnonymousBlockMatch(RecognizerBase<EHanaSQLScriptParserStates> state) {
        state.parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createRuleForLoops(ITokenMatcher endToken, ITokenMatcher ... startTokens) {
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(startTokens).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.DO}).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, endToken, ETokenType.SEMICOLON}).endNode();
    }

    private void createRulesForIfElse() {
        RecognizerBase<EHanaSQLScriptParserStates> ifAlternative = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.THEN, ETokenType.CASE, ETokenType.END).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE, ETokenType.END}));
        ifAlternative.sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.IF, ETokenType.SEMICOLON}).endNode();
        ifAlternative.endNodeWithContinuation();
        RecognizerBase<EHanaSQLScriptParserStates> elseMatcher = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS);
        elseMatcher.sequence(new ITokenMatcher[]{ETokenType.END}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        elseMatcher.sequenceBefore(new ITokenMatcher[]{ETokenType.END, ETokenType.CASE}).endNode();
    }

    private void createRulesForCaseElse() {
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.CASE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).endNode();
        this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.WHEN}).skipAfter(new ITokenMatcher[]{ETokenType.THEN}).createNode(EShallowEntityType.STATEMENT, "when", INameResolver.secondMatchedTokenText()).endNode();
    }

    private void createRulesForVariablesConstants() {
        RecognizerBase declareMatch = this.inState(new EHanaSQLScriptParserStates[]{EHanaSQLScriptParserStates.METHOD_STATEMENTS}).sequence(new ITokenMatcher[]{ETokenType.DECLARE});
        declareMatch.sequence(new ITokenMatcher[]{ETokenType.CURSOR}).skipAfter(new ITokenMatcher[]{ETokenType.FOR}).createNode(EShallowEntityType.ATTRIBUTE, "cursor", INameResolver.ofIndex(2)).sequence(new ITokenMatcher[]{ETokenType.SELECT}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        RecognizerBase exitHandlerMatch = declareMatch.sequence(new ITokenMatcher[]{ETokenType.EXIT, ETokenType.HANDLER, ETokenType.FOR});
        RecognizerBase<EHanaSQLScriptParserStates> exitHandlerForSQLExceptionAndConditionMatch = exitHandlerMatch.sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SQLEXCEPTION, ETokenType.IDENTIFIER}));
        RecognizerBase<EHanaSQLScriptParserStates> exitHandlerForSQLErrorMatch = exitHandlerMatch.sequence(new ITokenMatcher[]{ETokenType.SQL_ERROR_CODE, ETokenType.INTEGER_LITERAL});
        HanaSQLScriptShallowParser.completeRuleForExitHandlerBlocks(exitHandlerForSQLExceptionAndConditionMatch, -2);
        HanaSQLScriptShallowParser.completeRuleForExitHandlerBlocks(exitHandlerForSQLErrorMatch, -3);
        exitHandlerForSQLExceptionAndConditionMatch.createNode(EShallowEntityType.ATTRIBUTE, "exit handler", INameResolver.previousTokenText()).optional(new ITokenMatcher[]{ETokenType.SELECT}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        exitHandlerForSQLErrorMatch.createNode(EShallowEntityType.ATTRIBUTE, "exit handler", INameResolver.ofIndex(-2)).optional(new ITokenMatcher[]{ETokenType.SELECT}).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        declareMatch.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.CONDITION}).optional(new ITokenMatcher[]{ETokenType.FOR, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "condition variable", INameResolver.secondMatchedTokenText()).endNode();
        declareMatch.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(HANA_SQLSCRIPT_IDENTIFIERS).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private static void completeRuleForExitHandlerBlocks(RecognizerBase<EHanaSQLScriptParserStates> state, int pos) {
        state.sequence(new ITokenMatcher[]{ETokenType.BEGIN}).createNode(EShallowEntityType.STATEMENT, "exit handler block", INameResolver.ofIndex(pos)).parseUntil(EHanaSQLScriptParserStates.METHOD_STATEMENTS).sequence(new ITokenMatcher[]{ETokenType.END, ETokenType.SEMICOLON}).endNode();
    }

    public static enum EHanaSQLScriptParserStates {
        OUTSIDE_METHODS,
        METHOD_STATEMENTS;

    }
}

