/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.javascript;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptShallowParser;
import java.util.List;

public class GenericTypeAssigningEqualsRecognizer
extends RecognizerBase<JavaScriptShallowParser.EJavaScriptParserStates> {
    private static final ITokenMatcher POTENTIAL_EQUALITY_SYMBOLS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RSHIFTEQ, ETokenType.GTEQ, ETokenType.EQ});
    private final boolean canEndWithoutEqualitySymbol;

    public GenericTypeAssigningEqualsRecognizer() {
        this.canEndWithoutEqualitySymbol = false;
    }

    public GenericTypeAssigningEqualsRecognizer(boolean canEndWithoutEqualitySymbol) {
        this.canEndWithoutEqualitySymbol = canEndWithoutEqualitySymbol;
    }

    @Override
    protected int matchesLocally(ParserState<JavaScriptShallowParser.EJavaScriptParserStates> parserState, List<IToken> tokens, int startOffset) {
        int angleBracketCount = 0;
        for (int i = startOffset; i < tokens.size(); ++i) {
            ETokenType tokenType = tokens.get(i).getType();
            switch (tokenType) {
                case LT: {
                    ++angleBracketCount;
                    break;
                }
                case RSHIFTEQ: {
                    angleBracketCount -= 2;
                    break;
                }
                case GT: 
                case GTEQ: {
                    --angleBracketCount;
                    break;
                }
            }
            if (!POTENTIAL_EQUALITY_SYMBOLS.matches(tokens.get(i)) && !this.canEndWithoutEqualitySymbol || angleBracketCount != 0) continue;
            return i + 1;
        }
        return -1;
    }
}

