/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.objectivec;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.CStyleShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import java.util.List;
import java.util.Set;

public final class AppleBlockSyntaxRecognizer
extends RecognizerBase<EGenericParserStates> {
    @Override
    protected int matchesLocally(ParserState<EGenericParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (AppleBlockSyntaxRecognizer.isBlockSyntaxOperator(tokens, startOffset)) {
            if (ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.LBRACE}).matches(tokens.get(startOffset + 1))) {
                int indexOfBodyOpeningLbrace = CStyleShallowParserBase.skipOptionalParameters(tokens, startOffset + 1);
                if (indexOfBodyOpeningLbrace != -1 && indexOfBodyOpeningLbrace < tokens.size() && ETokenType.LBRACE.matches(tokens.get(indexOfBodyOpeningLbrace))) {
                    return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
                }
            } else {
                int parameterListStartOrLambdaBodyStartIndex = AppleBlockSyntaxRecognizer.getParameterListStartOrLambdaBodyStartIndex(tokens, startOffset);
                if (parameterListStartOrLambdaBodyStartIndex == -1) {
                    return -1;
                }
                switch (tokens.get(parameterListStartOrLambdaBodyStartIndex).getType()) {
                    case LBRACE: {
                        int paramRparenIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset + 2, parameterListStartOrLambdaBodyStartIndex, (ITokenMatcher)ETokenType.RPAREN);
                        if (paramRparenIndex != -1) break;
                        return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
                    }
                    case LPAREN: {
                        int parameterRparenIndex = TokenStreamUtils.findMatchingClosingToken(tokens, parameterListStartOrLambdaBodyStartIndex + 1, ETokenType.LPAREN, ETokenType.RPAREN);
                        if (parameterRparenIndex == -1 || tokens.get(parameterRparenIndex + 1).getType() != ETokenType.LBRACE) break;
                        return parserState.parse(EGenericParserStates.IN_EXPRESSION, tokens, startOffset);
                    }
                }
            }
        }
        return -1;
    }

    private static int getParameterListStartOrLambdaBodyStartIndex(List<IToken> tokens, int startOffset) {
        int parameterListStartOrLambdaBodyStartIndex = TokenStreamUtils.firstTokenMatching(tokens, startOffset + 2, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.COMMA, ETokenType.OROR, ETokenType.ANDAND, ETokenType.LT}));
        if (parameterListStartOrLambdaBodyStartIndex == -1) {
            return -1;
        }
        while (tokens.get(parameterListStartOrLambdaBodyStartIndex).getType() == ETokenType.LT) {
            int endTokenIndex;
            if ((endTokenIndex = TokenStreamUtils.findMatchingClosingToken(tokens, ++parameterListStartOrLambdaBodyStartIndex, ETokenType.LT, ETokenType.GT)) == -1) {
                return -1;
            }
            parameterListStartOrLambdaBodyStartIndex = TokenStreamUtils.firstTokenMatching(tokens, endTokenIndex, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.SEMICOLON, ETokenType.COMMA, ETokenType.OROR, ETokenType.ANDAND, ETokenType.LT}));
            if (parameterListStartOrLambdaBodyStartIndex != -1) continue;
            return -1;
        }
        return parameterListStartOrLambdaBodyStartIndex;
    }

    private static boolean isBlockSyntaxOperator(List<IToken> tokens, int operatorIndex) {
        return tokens.get(operatorIndex).getType() == ETokenType.XOR && operatorIndex + 2 < tokens.size() && !AppleBlockSyntaxRecognizer.isArithmeticBitwiseXorOperator(tokens, operatorIndex);
    }

    private static boolean isArithmeticBitwiseXorOperator(List<IToken> tokens, int operatorIndex) {
        int closingParenIndex;
        if (operatorIndex == 0 || tokens.size() < 2 || operatorIndex + 2 >= tokens.size()) {
            return false;
        }
        if (tokens.get(operatorIndex + 1).getType() == ETokenType.LPAREN && (closingParenIndex = TokenStreamUtils.findMatchingClosingToken(tokens, operatorIndex + 2, ETokenType.LPAREN, ETokenType.RPAREN)) != -1 && closingParenIndex + 1 < tokens.size() && tokens.get(closingParenIndex + 1).getType() == ETokenType.LBRACE) {
            return false;
        }
        return tokens.get(operatorIndex).getType() == ETokenType.XOR && Set.of(ETokenType.INTEGER_LITERAL, ETokenType.IDENTIFIER, ETokenType.RPAREN).contains(tokens.get(operatorIndex - 1).getType()) && Set.of(ETokenType.INTEGER_LITERAL, ETokenType.IDENTIFIER, ETokenType.LPAREN).contains(tokens.get(operatorIndex + 1).getType());
    }
}

