/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.util.ObjectiveCLanguageFeatureParserBase;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.Pair;

public class ObjectiveCppLanguageFeatureParser
extends ObjectiveCLanguageFeatureParserBase {
    ObjectiveCppLanguageFeatureParser() {
        super(ELanguage.OBJECTIVE_CPP, CppShallowParser.TYPES_TOKENS, new CLikeVariableUseExtractor(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.POINTERTO, ETokenType.SCOPE}), VALID_IDENTIFIERS));
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && (entity.getSubtype().equals("@import") || entity.getSubtype().equals("using namespace"));
    }

    @Override
    public String getImportName(ShallowEntity entity) {
        if (entity.getSubtype().equals("using namespace")) {
            return entity.getName();
        }
        return super.getImportName(entity);
    }

    @Override
    public List<IToken> extractParameterTokens(List<IToken> methodStartTokens) {
        if (methodStartTokens.stream().anyMatch(token -> token.getType() == ETokenType.COLON)) {
            return ObjectiveCppLanguageFeatureParser.extractObjectiveCParameterTokens(methodStartTokens);
        }
        return super.extractParameterTokens(methodStartTokens);
    }

    @Override
    public Pair<List<IToken>, String> getModifiersAndReturnType(ShallowEntity method) {
        ShallowEntity parent = method.getParent();
        if (parent != null && (Objects.equals(parent.getSubtype(), "@interface") || Objects.equals(parent.getSubtype(), "@implementation"))) {
            return this.getObjectiveCReturnTypeAndModifiers(method);
        }
        return super.getModifiersAndReturnType(method);
    }
}

