/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum EDefaultSpecItemLinkRole {
    PARENT("has parent", "is parent of"),
    IMPLEMENTS("implements", "is implemented by"),
    REFINES("refines", "is refined by"),
    DEPENDS_ON("depends on", "blocks"),
    DUPLICATES("duplicates", "is duplicated by"),
    FOLLOW_UP("has follow-up", "follows"),
    VERIFIES("verifies", "is verified by"),
    TESTS("tests", "tested by"),
    ASSESSES("assesses", "is assessed by"),
    TRIGGERED_BY("is triggered by", "triggers"),
    MITIGATES("mitigates", "is mitigated by"),
    AFFECTS("affects", "is affected by"),
    TRACKS("tracks", "is tracked by"),
    DERIVED_FROM("is derived from", "is derived by"),
    BRANCHED_FROM("is branched from", "has branch"),
    RELATES_TO("relates to", "is related to"),
    USES("uses", "is used by"),
    BLOCKS("blocks", "is blocked by"),
    COPY("is copied by", "is copy of"),
    RESULT("promotes", "is included in promotion");

    private static final Map<String, EDefaultSpecItemLinkRole> nameToRoleAndOppositeMap;
    private final String linkRoleName;
    private final String oppositeLinkRoleName;
    private final String mergedLinkRoleName;

    private EDefaultSpecItemLinkRole(String linkRoleName, String oppositeLinkRoleName) {
        this(linkRoleName, oppositeLinkRoleName, linkRoleName + "/" + oppositeLinkRoleName);
    }

    private EDefaultSpecItemLinkRole(String linkRoleName, String oppositeLinkRoleName, String mergedLinkRoleName) {
        this.linkRoleName = linkRoleName;
        this.oppositeLinkRoleName = oppositeLinkRoleName;
        this.mergedLinkRoleName = mergedLinkRoleName;
    }

    public String getLinkRoleName() {
        return this.linkRoleName;
    }

    public String getOppositeLinkRoleName() {
        return this.oppositeLinkRoleName;
    }

    public String getMergedLinkRoleName() {
        return this.mergedLinkRoleName;
    }

    public static List<String> getOppositesOf(Collection<String> linkRoles) {
        ArrayList<String> result = new ArrayList<String>(linkRoles.size());
        for (String role : linkRoles) {
            EDefaultSpecItemLinkRole roleEnum = nameToRoleAndOppositeMap.get(role.toLowerCase());
            if (roleEnum == null) {
                throw new IllegalArgumentException(String.format("Role '%s' does not have a known inverse role!", role));
            }
            result.add(roleEnum.oppositeLinkRoleName);
        }
        return result;
    }

    static {
        nameToRoleAndOppositeMap = new HashMap<String, EDefaultSpecItemLinkRole>();
        for (EDefaultSpecItemLinkRole role : EDefaultSpecItemLinkRole.values()) {
            nameToRoleAndOppositeMap.put(role.linkRoleName, role);
            nameToRoleAndOppositeMap.put(role.oppositeLinkRoleName, role);
        }
    }
}

