/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.wia.EWorkItemType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@IndexValueClass(containedInBackup=true)
public class TeamscaleIssueId
implements Serializable,
Comparable<TeamscaleIssueId> {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_DESCRIPTION = "The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".";
    public static final String SEPARATOR = "|";
    private static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String CONNECTOR_ID_PROPERTY = "connectorId";
    private static final String EXTERNAL_ID_PROPERTY = "externalId";
    @JsonProperty(value="internalId")
    private final String internalId;
    @JsonProperty(value="connectorId")
    private final String connectorId;
    @JsonProperty(value="externalId")
    private final String externalId;

    @JsonCreator
    public TeamscaleIssueId(@JsonProperty(value="internalId") String internalId, @JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="externalId") String externalId) {
        CCSMAssert.isNotNull((Object)internalId, () -> String.format("Expected \"%s\" to be not null", INTERNAL_ID_PROPERTY));
        CCSMAssert.isNotNull((Object)connectorId, () -> String.format("Expected \"%s\" to be not null", CONNECTOR_ID_PROPERTY));
        CCSMAssert.isNotNull((Object)externalId, () -> String.format("Expected \"%s\" to be not null", EXTERNAL_ID_PROPERTY));
        this.internalId = internalId;
        this.connectorId = connectorId;
        this.externalId = externalId;
    }

    public TeamscaleIssueId(String connectorId, String externalId) {
        CCSMAssert.isNotEmpty((String)connectorId, () -> String.format("Expected \"%s\" to be not empty", CONNECTOR_ID_PROPERTY));
        CCSMAssert.isNotEmpty((String)externalId, () -> String.format("Expected \"%s\" to be not empty", EXTERNAL_ID_PROPERTY));
        this.connectorId = connectorId;
        this.externalId = externalId;
        this.internalId = TeamscaleIssueId.computeInternalId(connectorId, externalId);
    }

    public static TeamscaleIssueId fromInternalId(String value) {
        CCSMAssert.isNotNull((Object)value, () -> String.format("Expected \"%s\" to be not null", "value"));
        int separatorIndex = value.indexOf(SEPARATOR);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid TeamscaleIssueId. Must adhere to the format \"<connectorId>|<issueId>\"", value));
        }
        String connectorId = value.substring(0, separatorIndex);
        String externalId = value.substring(separatorIndex + 1);
        return new TeamscaleIssueId(connectorId, externalId);
    }

    public static boolean isValidInternalId(String value) {
        return value.contains(SEPARATOR);
    }

    public TeamscaleIssueId withExternalId(String externalId) {
        return new TeamscaleIssueId(this.connectorId, externalId);
    }

    public UniformPath computeUniformPath(EWorkItemType workItemType) {
        return this.computeUniformPath(workItemType.getUniformPathType());
    }

    public UniformPath computeUniformPath(UniformPath.EType uniformPathType) {
        return UniformPath.ofSegments((UniformPath.EType)uniformPathType, (String[])new String[]{this.connectorId, UniformPath.escapeSegment((String)this.externalId)});
    }

    public List<UniformPath> toPossibleUniformPaths() {
        return Arrays.stream(EWorkItemType.values()).map(this::computeUniformPath).distinct().collect(Collectors.toList());
    }

    public static <T, E extends Exception> T calculateBasedOnUniformPath(UniformPath uniformPath, FunctionWithException<UniformPath.EType, T, E> onRootPath, BiFunctionWithException<UniformPath.EType, String, T, E> onConnectorPath, BiFunctionWithException<UniformPath.EType, TeamscaleIssueId, T, E> onItemIdPath) throws E {
        if (!EWorkItemType.UNIFORM_PATH_TYPES.contains((Object)uniformPath.getType())) {
            throw new IllegalArgumentException(String.format("UniformPath %s is not a Work Item Uniform Path", uniformPath));
        }
        switch (uniformPath.getPathSegments().size()) {
            case 0: {
                return (T)onRootPath.apply((Object)uniformPath.getType());
            }
            case 1: {
                return (T)onConnectorPath.apply((Object)uniformPath.getType(), (Object)uniformPath.getLastSegment());
            }
            case 2: {
                return (T)onItemIdPath.apply((Object)uniformPath.getType(), (Object)new TeamscaleIssueId((String)uniformPath.getPathSegments().get(0), uniformPath.getLastSegment()));
            }
        }
        throw new IllegalArgumentException(String.format("Received malformed Work Item Uniform Path %s. Expected at most 2 segments but got %d", uniformPath, uniformPath.getPathSegments().size()));
    }

    public String getInternalId() {
        return this.internalId;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public int compareTo(@NonNull TeamscaleIssueId o) {
        int compare = this.externalId.compareTo(o.externalId);
        if (compare == 0) {
            compare = this.connectorId.compareTo(o.connectorId);
        }
        return compare;
    }

    public String toString() {
        return this.internalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamscaleIssueId id = (TeamscaleIssueId)o;
        return this.internalId.equalsIgnoreCase(id.internalId);
    }

    public int hashCode() {
        return Objects.hash(this.internalId);
    }

    public static String computeInternalId(String connectorId, String externalId) {
        CCSMAssert.isFalse((boolean)connectorId.contains(SEPARATOR), () -> String.format("Connector ID \"%s\" must not contain \"%s\"", connectorId, SEPARATOR));
        return connectorId + SEPARATOR + externalId;
    }
}

