/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core;

import com.microsoft.tfs.core.FrameworkServerDataProvider;
import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.PreFrameworkServerDataProvider;
import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.commonstructure.CommonStructureClient;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.catalog.ICatalogService;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.catalog.ProjectCollectionCatalogEntity;
import com.microsoft.tfs.core.clients.framework.configuration.catalog.TeamProjectCatalogEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSEntitySessionFactory;
import com.microsoft.tfs.core.clients.framework.location.ConnectOptions;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.core.clients.framework.location.LocationServiceConstants;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.versioncontrol.SourceControlCapabilityFlags;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.config.DefaultConnectionAdvisor;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TFSTeamProjectCollection
extends TFSConnection {
    private static final Log log = LogFactory.getLog(TFSTeamProjectCollection.class);
    private TFSConfigurationServer configurationServer;
    private final Object configurationServerLock = new Object();
    private ServerDataProvider serverDataProvider;
    private final Object serverDataProviderLock = new Object();
    private TFSEntitySession configurationSession;
    private final Object configurationSessionLock = new Object();

    public TFSTeamProjectCollection(URI serverURI, Credentials credentials) {
        this(serverURI, credentials, (ConnectionAdvisor)new DefaultConnectionAdvisor(Locale.getDefault(), TimeZone.getDefault()));
    }

    public TFSTeamProjectCollection(URI serverURI, Credentials credentials, ConnectionAdvisor advisor) {
        this(serverURI, new AtomicReference<Credentials>(credentials), advisor);
    }

    protected TFSTeamProjectCollection(URI serverURI, AtomicReference<Credentials> credentialsHolder, ConnectionAdvisor advisor) {
        super(serverURI, credentialsHolder, advisor, "/Services/v3.0/LocationService.asmx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerDataProvider getServerDataProvider() {
        this.checkNotClosed();
        Object object = this.serverDataProviderLock;
        synchronized (object) {
            if (this.serverDataProvider == null) {
                try {
                    FrameworkServerDataProvider tempFrameworkProvider = new FrameworkServerDataProvider(this);
                    if (tempFrameworkProvider.hasLocalCacheDataForConnection()) {
                        this.serverDataProvider = tempFrameworkProvider;
                    } else {
                        PreFrameworkServerDataProvider tempPreFrameworkProvider = new PreFrameworkServerDataProvider(this);
                        String locationServiceLocation = tempPreFrameworkProvider.locationForCurrentConnection("LocationService", LocationServiceConstants.SELF_REFERENCE_LOCATION_SERVICE_IDENTIFIER);
                        if (locationServiceLocation == null) {
                            log.error((Object)MessageFormat.format("You cannot connect to {0} because it is running a version of Team Foundation Server that is not supported by your version of Visual Studio. Upgrade your server to Team Foundation Server 2010 (or a newer version), or use Visual Studio 2010, Visual Studio 2012 or Visual Studio 2015.", this.getBaseURI()));
                            throw new NotSupportedException(MessageFormat.format(Messages.getString("TFSTeamProjectCollection.NotSupportedTfsVersionFormat"), this.getBaseURI()));
                        }
                        tempFrameworkProvider.connect(ConnectOptions.INCLUDE_SERVICES);
                        this.serverDataProvider = tempFrameworkProvider;
                    }
                }
                catch (RuntimeException e) {
                    log.warn((Object)"Error getting data provider", (Throwable)e);
                    throw e;
                }
            }
            return this.serverDataProvider;
        }
    }

    @Override
    protected ICatalogService getCatalogService() {
        this.checkNotClosed();
        return this.getConfigurationServer().getCatalogService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSConfigurationServer getConfigurationServer() {
        this.checkNotClosed();
        Object object = this.configurationServerLock;
        synchronized (object) {
            String location;
            if (this.configurationServer == null && (location = this.getServerDataProvider().locationForCurrentConnection("LocationService", LocationServiceConstants.APPLICATION_LOCATION_SERVICE_IDENTIFIER)) != null && location.length() > 0) {
                URI locationURI = URIUtils.newURI(location);
                this.configurationServer = new TFSConfigurationServer(locationURI, this.getCredentialsHolder(), this.getConnectionAdvisor());
                this.configurationServer.setHTTPClientReference(this.getHTTPClientReference());
            }
            return this.configurationServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed()) {
            this.warnClosed();
            return;
        }
        super.close();
        Object object = this.configurationServerLock;
        synchronized (object) {
            if (this.configurationServer != null && !this.configurationServer.isClosed()) {
                this.configurationServer.close();
            }
            this.configurationServer = null;
        }
    }

    public ILocationService getCollectionLocationService() {
        this.checkNotClosed();
        return (ILocationService)this.getClient(ILocationService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntitySession getConfigurationSession(boolean refresh) {
        this.checkNotClosed();
        Object object = this.configurationSessionLock;
        synchronized (object) {
            if (this.configurationSession == null || refresh) {
                this.configurationSession = TFSEntitySessionFactory.newEntitySession(this);
            }
            return this.configurationSession;
        }
    }

    public ProjectCollectionEntity getTeamProjectCollectionEntity(boolean refresh) {
        this.checkNotClosed();
        TFSEntitySession configurationSession = this.getConfigurationSession(refresh);
        if (configurationSession == null || configurationSession.getOrganizationalRoot() == null) {
            return null;
        }
        if (configurationSession.getOrganizationalRoot().getTeamFoundationServer() == null) {
            log.warn((Object)"Could not load Team Foundation Server entity from organizational root");
            return null;
        }
        ProjectCollectionEntity collectionEntity = configurationSession.getOrganizationalRoot().getTeamFoundationServer().getProjectCollection(this.getInstanceID());
        if (collectionEntity == null) {
            log.warn((Object)MessageFormat.format("Could not load Team Project Collection entity for instance id {0}", this.getInstanceID()));
        }
        return collectionEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasAuthenticated() {
        ServerDataProvider serverDataProvider;
        this.checkNotClosed();
        Object object = this.serverDataProviderLock;
        synchronized (object) {
            serverDataProvider = this.serverDataProvider;
        }
        return serverDataProvider != null ? serverDataProvider.hasAuthenticated() : false;
    }

    @Override
    public RegistrationClient getRegistrationClient() {
        this.checkNotClosed();
        return (RegistrationClient)this.getClient(RegistrationClient.class);
    }

    public VersionControlClient getVersionControlClient() {
        this.checkNotClosed();
        return (VersionControlClient)this.getClient(VersionControlClient.class);
    }

    public WorkItemClient getWorkItemClient() {
        this.checkNotClosed();
        return (WorkItemClient)this.getClient(WorkItemClient.class);
    }

    public IBuildServer getBuildServer() {
        this.checkNotClosed();
        return (IBuildServer)this.getClient(IBuildServer.class);
    }

    public CommonStructureClient getCommonStructureClient() {
        this.checkNotClosed();
        return (CommonStructureClient)this.getClient(CommonStructureClient.class);
    }

    public SourceControlCapabilityFlags getSourceControlCapability(ProjectInfo project) {
        this.checkNotClosed();
        if (this.getVersionControlClient().getWebServiceLayer().getServiceLevel().getValue() < WebServiceLevel.TFS_2012_QU1.getValue()) {
            return SourceControlCapabilityFlags.TFS;
        }
        try {
            TeamProjectCatalogEntity projectCatalogEntry;
            ProjectCollectionCatalogEntity collectionCatalogEntry = (ProjectCollectionCatalogEntity)this.getTeamProjectCollectionEntity(false);
            if (collectionCatalogEntry == null) {
                collectionCatalogEntry = (ProjectCollectionCatalogEntity)this.getTeamProjectCollectionEntity(true);
            }
            if ((projectCatalogEntry = (TeamProjectCatalogEntity)collectionCatalogEntry.getTeamProject(new GUID(project.getGUID()))) == null) {
                collectionCatalogEntry = (ProjectCollectionCatalogEntity)this.getTeamProjectCollectionEntity(true);
                projectCatalogEntry = (TeamProjectCatalogEntity)collectionCatalogEntry.getTeamProject(new GUID(project.getGUID()));
            }
            SourceControlCapabilityFlags sourceControlCapabilityFlag = SourceControlCapabilityFlags.NONE;
            if (projectCatalogEntry.isGitSupported()) {
                sourceControlCapabilityFlag = sourceControlCapabilityFlag.combine(SourceControlCapabilityFlags.GIT);
            }
            if (projectCatalogEntry.isTfvcSupported()) {
                sourceControlCapabilityFlag = sourceControlCapabilityFlag.combine(SourceControlCapabilityFlags.TFS);
            }
            return sourceControlCapabilityFlag;
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error accessing Catalog Entry: ", (Throwable)e);
            return SourceControlCapabilityFlags.TFS;
        }
    }
}

