/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.internal.soapextensions.PropertyValue;
import java.util.Map;
import java.util.TreeMap;

public class AttachedPropertyDictionary
extends TreeMap<String, Object> {
    private final Map<String, Object> delta;

    public AttachedPropertyDictionary() {
        this.delta = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    }

    public AttachedPropertyDictionary(PropertyValue[] properties) {
        for (PropertyValue value : properties) {
            this.put(value.getPropertyName(), value.getInternalValue());
        }
        this.delta = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    }

    public void clearChangedProperties() {
        this.delta.clear();
    }

    public void copyFrom(Map<String, Object> source) {
        String[] keys;
        for (String key : keys = this.keySet().toArray(new String[this.size()])) {
            if (source.containsKey(key)) continue;
            this.remove(key);
        }
        for (Map.Entry pair : this.entrySet()) {
            this.put(pair.getKey(), pair.getValue());
        }
    }

    public PropertyValue[] getChangedProperties() {
        PropertyValue[] properties = new PropertyValue[this.delta.size()];
        int index = 0;
        for (Map.Entry<String, Object> pair : this.delta.entrySet()) {
            properties[index++] = new PropertyValue(pair.getKey(), pair.getValue());
        }
        return properties;
    }
}

